/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.FullCanvas;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

class mainCanvas
extends FullCanvas {
    private COD cod;
    private static final short LEFT_SOFTKEY = -6;
    private static final short RIGHT_SOFTKEY = -7;
    private static final byte pagemargin = 4;
    private static final int ROWMAX = 128;
    private static final int COLMAX = 11;
    private static final int MAP_HEIGHT = 2048;
    private static final int MAP_WIDTH = 176;
    private static final int SCREEN_MARGIN = 55;
    private static final byte SCREEN_SPEED_MAX = 6;
    private static final byte PLAYER_MAX = 3;
    private static final byte OPPONENT_MAX = 42;
    private static final byte SPECIAL_MAX = 40;
    private static final byte SQUARE_MAX = 30;
    private static final byte PROJECTILE_MAX = 40;
    private static final byte PROJECTILE_TIME_MAX_BULLET = 16;
    private static final byte PROJECTILE_TIME_MAX_GRENADE = 8;
    private static final byte PROJECTILE_TIME_MAX_EXPLOSIVES = 38;
    private static final byte PROJECTILE_TIME_MAX_RIFLE = 2;
    private static final byte EXPLOSION_FRAMES = 4;
    private static final byte SMOKE_FRAMES = 14;
    private static final byte DEATH_FRAMES = 30;
    private static final byte SHOT_DELAY_AXIS = 20;
    private static final byte SHOT_DELAY_AI = 10;
    private static final byte SHOT_DELAY_GRENADE = 10;
    private static final byte SHOT_DELAY_RIFLE = 10;
    private static final byte SHOT_DELAY_EXPLOSIVES = 10;
    private static final byte HEALING_DELAY = 60;
    private static final int FLAK_JACKET_TIME = 180;
    private static final byte[] INITIAL_AMMO = new byte[]{10, 5, 5};
    private static final byte[] INITIAL_HEALTH = new byte[]{2, 1, 3, 2, 3};
    private static final byte SHOW_STATUS_TIME = 60;
    private static final byte STATUS_BAR_WIDTH = 66;
    private static final byte STATUS_BAR_HEIGHT = 14;
    private static final byte SHOW_ORDERS_TIME = 50;
    private static final int INVISIBILITY_TIME = 180;
    private static final short screen_splash = 0;
    private static final short screen_menu = 1;
    private static final short screen_play = 2;
    private static final short screen_rules_menu = 3;
    private static final short screen_options = 4;
    private static final short screen_options_ingame = 5;
    private static final short screen_mission = 6;
    private static final short screen_briefing = 7;
    private static final short screen_briefing_no_back = 8;
    private static final short screen_squad_select = 9;
    private static final short screen_squad_confirm = 10;
    private static final short screen_end_level = 11;
    private static final short screen_player_dead = 12;
    private static final short screen_reset_confirm = 13;
    private static final short screen_exit = 14;
    private static final short timer_loop = 0;
    private static final short timer_splash = 1;
    private static final short timer_menu_anim = 2;
    private static final short timer_suspend_key_presses = 3;
    private static final int DELAY_LOOP = 50;
    private static final int DELAY_SPLASH_ACTIVISION = 2500;
    private static final int DELAY_SPLASH_NGAME = 2000;
    private static final int DELAY_SPLASH_TITLE = 3000;
    private static final int DELAY_ANIM = 100;
    private static final int DELAY_SUSPEND = 750;
    private static final byte TEXTURE_GRASS = 0;
    private static final byte TEXTURE_TREE_TOP = 26;
    private static final byte TEXTURE_WINDOW = 28;
    private int height;
    private int width;
    private int halfHeight;
    private int halfWidth;
    private short fontHeight;
    private short largeFontHeight;
    private Font font;
    private Font largeFont;
    private Timer timer;
    private SimpleTimerTask simpletimertask;
    private short screenType;
    private byte missionNumberCurrent;
    private byte missionNumberMax;
    private static final byte MISSION_COUNT = 9;
    private boolean endLevel;
    private Image tilesImage;
    private Image unitImage;
    private Image enemyImage;
    private Image screenImage;
    private Image specialImage;
    private Image craterImage;
    private Image smokeImage;
    private Image explosionImage;
    private Image symbolsImage;
    private Image statusBar;
    private Image splashImage;
    private Image titleImage;
    private Image selectImage;
    private Image arrowsImage;
    private Image menuImage;
    private short menuStart;
    private short menuLines;
    private short menuGraphicHeight;
    private short menuLineHeight;
    private short menuLength;
    private short menuSelection;
    private String[] menuStringArray;
    private Graphics screenImageGraphics;
    private int screenImageLeft;
    private int screenImageTop;
    private int screenImageHeight;
    private int screenSplit;
    private int screenImageDiscontinuity;
    private byte[] projectileArrayNext = new byte[40];
    private byte projectileArrayUsedStart;
    private byte projectileArrayUnusedStart;
    private int[] projectileX = new int[40];
    private int[] projectileY = new int[40];
    private byte[] projectileDirection = new byte[40];
    private byte[] projectileTime = new byte[40];
    private byte[] projectileType = new byte[40];
    private byte opponentArrayStart;
    private byte[] playerArrayNext = new byte[45];
    private byte playerArrayStart;
    private byte currentPlayer;
    private boolean takeCover;
    private int[] playerX = new int[45];
    private int[] playerY = new int[45];
    private byte[] playerDirection = new byte[45];
    private boolean[] playerMoving = new boolean[45];
    private byte[] playerHealth = new byte[45];
    private int[] playerNextShot = new int[45];
    private int[] playerAimX = new int[2];
    private int[] playerAimY = new int[2];
    private byte[] playerType = new byte[3];
    private int[] playerSpecial = new int[3];
    private int[] playerProtected = new int[3];
    private boolean[] playerInBuilding = new boolean[3];
    private int[] playerShowStatus = new int[3];
    private byte[] specialArrayNext = new byte[40];
    private byte[] specialArrayPrevious = new byte[40];
    private byte specialArrayStart;
    private byte specialArrayExplodableStart;
    private int[] specialX = new int[40];
    private int[] specialY = new int[40];
    private byte[] specialType = new byte[40];
    private byte[] specialDamage = new byte[40];
    private byte[] squarePlayer = new byte[30];
    private byte[] squareRow = new byte[30];
    private byte[] squareCol = new byte[30];
    private byte squareMax;
    private int currentKeyCode;
    private int nextKeyCode;
    private byte frameCount;
    private int clockTicks;
    private int showOrders;
    private boolean soundOn;
    private boolean allowKeyPresses = true;
    private Random random = new Random();
    private byte[] soundWAV = new byte[96300];
    private Sound sound;
    private int[] missionTime = new int[10];
    private long startTime;
    private final boolean is3650 = this.getGameAction(35) == 8;
    private final int CHANGE_ORDERS = this.is3650 ? 54 : 48;
    private byte[][] MapData = new byte[128][11];
    private byte[] TileTextureData;
    private byte[] TileBlockData;
    private byte[] TileSpecialData;
    private static final byte PLAYER_INFANTRY = 0;
    private static final byte PLAYER_SNIPER = 1;
    private static final byte PLAYER_ENGINEER = 2;
    private static final byte PLAYER_COMMANDO = 3;
    private static final byte PLAYER_MEDIC = 4;
    private static final byte SPECIAL_TANK = 0;
    private static final byte SPECIAL_JEEP = 1;
    private static final byte SPECIAL_V2 = 2;
    private static final byte SPECIAL_GENERATOR = 3;
    private static final byte SPECIAL_DOOR = 4;
    private static final byte SPECIAL_FLAK_JACKET = 5;
    private static final byte SPECIAL_MEDIPACK = 6;
    private static final byte SPECIAL_AMMUNITION = 7;
    private static final byte SPECIAL_END = 8;
    private static final byte SPECIAL_BACK_DOOR = 9;
    private static final byte[] SPECIAL_GFX_X = new byte[]{0, 0, 32, 80, 80, 0, 16, 32};
    private static final byte[] SPECIAL_GFX_Y = new byte[]{0, 32, 32, 0, 64, 64, 64, 64};
    private static final byte[] SPECIAL_GFX_W = new byte[]{64, 32, 16, 64, 32, 16, 16, 16, 16, 32};
    private static final byte[] SPECIAL_GFX_H = new byte[]{32, 32, 32, 64, 16, 16, 16, 16, 16, 16};
    private static final byte[] CRATER_GFX_X = new byte[]{0, 0, 32, 0, 32};
    private static final byte[] CRATER_GFX_Y = new byte[]{0, 32, 48, 0, 32};
    private static final byte[] CRATER_GFX_W = new byte[]{64, 32, 16, 64, 32};
    private static final byte[] CRATER_GFX_H = new byte[]{32, 32, 32, 32, 16};
    private static final byte[] CRATER_DRAW_Y = new byte[]{0, 0, 16, 23, 0};
    private static final byte EXPLOSIVES_GFX_X = 48;
    private static final byte EXPLOSIVES_GFX_Y = 32;
    private static final byte FLAG_GFX_X = 48;
    private static final byte FLAG_GFX_Y = 48;
    private static final byte SECONDARY_GFX_X = 64;
    private static final byte FLAK_JACKET_GFX_X = 82;
    private static final byte DAGGER_GFX_X = 72;
    private static final byte DAGGER_GFX_Y = 6;
    private static final byte GUNFLARE_GFX_X = 74;
    private static final byte GUNFLARE_GFX_Y = 15;
    private static final byte PROJECTILE_BULLET = 99;
    private static final byte PROJECTILE_GRENADE = 0;
    private static final byte PROJECTILE_RIFLE = 1;
    private static final byte PROJECTILE_EXPLOSIVES = 2;
    private static final byte PROJECTILE_EXPLOSION = 10;
    private static final byte PROJECTILE_SMOKE = 11;
    private static final byte DAMAGE_BULLET = 1;
    private static final byte DAMAGE_RIFLE = 2;
    private static final byte DAMAGE_EXPLOSION = 2;
    private static final byte TILE_BLOCKED_IMPASSABLE = 0;
    private static final byte TILE_BLOCKED_DOOR = 1;
    private static final byte TILE_BLOCKED_WALK_UNDER = 2;
    private static final byte TILE_BLOCKED_WATER = 3;
    private static final byte TILE_BLOCKED_CLEAR = 4;
    private static final byte TILE_BLOCKED_BACK_DOOR = 5;
    private static final byte[] WEAPON_TYPE = new byte[]{0, 1, 2, 0, -1};
    private static final byte[] bulletDeltaX = new byte[]{-4, 0, 4, -6, 0, 6, -4, 0, 4};
    private static final byte[] bulletDeltaY = new byte[]{-4, -6, -4, 0, 0, 0, 4, 6, 4};
    private static final byte[] bulletClipDeltaX = new byte[]{11, 1, 0, 13, 0, 0, 11, 1, 0};
    private static final byte[] bulletClipDeltaY = new byte[]{11, 13, 11, 1, 0, 1, 0, 0, 0};
    private static final byte[] bulletImageDeltaX = new byte[]{69, 54, 66, 61, 0, 48, 77, 54, 58};
    private static final byte[] bulletImageDeltaY = new byte[]{80, 77, 80, 70, 0, 70, 69, 64, 69};
    private static final byte[] bulletClipWidth = new byte[]{11, 3, 11, 13, 0, 13, 11, 3, 11};
    private static final byte[] bulletClipHeight = new byte[]{11, 13, 11, 3, 0, 3, 11, 13, 11};
    private static final byte[] bulletEndDeltaX = new byte[]{-11, 0, 11, -13, 0, 13, -11, 0, 11};
    private static final byte[] bulletEndDeltaY = new byte[]{-11, -13, -11, 0, 0, 0, 11, 13, 11};
    private static final byte[] gunFlareX = new byte[]{0, 8, 15, 0, 0, 15, 0, 8, 15};
    private static final byte[] gunFlareY = new byte[]{5, 0, 5, 9, 0, 9, 10, 11, 10};

    public mainCanvas(COD cOD) {
        this.cod = cOD;
        this.font = Font.getFont((int)0, (int)0, (int)8);
        this.fontHeight = (short)this.font.getHeight();
        this.largeFont = Font.getFont((int)64, (int)1, (int)0);
        this.largeFontHeight = (short)this.largeFont.getHeight();
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.halfWidth = this.width >> 1;
        this.halfHeight = this.height >> 1;
        this.missionNumberCurrent = 0;
        this.missionNumberMax = 0;
        this.soundOn = true;
        int n = 0;
        while (n <= 9) {
            this.missionTime[n] = 0;
            ++n;
        }
        try {
            if (RecordStore.listRecordStores() == null) {
                this.writeRecords();
            } else {
                this.readRecords();
            }
        }
        catch (Exception exception) {
            System.out.println("Record Store not found");
        }
        try {
            this.tilesImage = Image.createImage((String)"/ground.png");
            this.unitImage = Image.createImage((String)"/player.png");
            this.enemyImage = Image.createImage((String)"/axis.png");
            this.specialImage = Image.createImage((String)"/special.png");
            this.craterImage = Image.createImage((String)"/craters.png");
            this.explosionImage = Image.createImage((String)"/explosion.png");
            this.smokeImage = Image.createImage((String)"/smoke.png");
            this.symbolsImage = Image.createImage((String)"/symbols.png");
            this.splashImage = Image.createImage((String)"/activision.png");
            this.titleImage = Image.createImage((String)"/title.png");
            this.selectImage = Image.createImage((String)"/select.png");
            this.arrowsImage = Image.createImage((String)"/arrows.png");
            this.menuImage = Image.createImage((String)"/menu.png");
            this.statusBar = Image.createImage((int)66, (int)this.fontHeight);
        }
        catch (Exception exception) {
            System.out.println("Images not found");
        }
        int n2 = (this.height >> 4) + 1;
        if ((this.height & 0xF) > 0) {
            ++n2;
        }
        this.screenImageHeight = n2 << 4;
        this.screenImage = Image.createImage((int)176, (int)this.screenImageHeight);
        this.screenImageGraphics = this.screenImage.getGraphics();
        this.GetSound("intro");
        this.PlaySound(1);
        this.screenType = 0;
        this.timer = new Timer();
        this.frameCount = 0;
        this.StartSimpleTimer((short)1, 2500);
    }

    private Image GetImage(String string) {
        try {
            return Image.createImage((String)("/" + string + ".png"));
        }
        catch (Exception exception) {
            System.out.println(string + ".png not found");
            return Image.createImage((int)1, (int)1);
        }
    }

    private void GetSound(String string) {
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + string + ".wav");
            inputStream.read(this.soundWAV, 0, this.soundWAV.length);
        }
        catch (Exception exception) {
            System.out.println("Error reading " + string + ".wav - " + exception);
        }
    }

    private void ReadMap() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        this.projectileArrayUsedStart = (byte)-1;
        this.projectileArrayUnusedStart = 0;
        int n12 = 38;
        while (n12 >= 0) {
            this.projectileArrayNext[n12] = (byte)(n12 + 1);
            --n12;
        }
        this.projectileArrayNext[39] = -1;
        this.screenImageLeft = 0;
        int n13 = 0;
        while (n13 < 3) {
            this.playerSpecial[n13] = this.playerType[n13] == 4 || this.playerType[n13] == 3 ? 0 : INITIAL_AMMO[WEAPON_TYPE[this.playerType[n13]]];
            this.playerHealth[n13] = INITIAL_HEALTH[this.playerType[n13]];
            this.playerNextShot[n13] = 0;
            this.playerDirection[n13] = 1;
            this.playerMoving[n13] = false;
            this.playerProtected[n13] = 0;
            this.playerInBuilding[n13] = false;
            this.playerShowStatus[n13] = 60;
            ++n13;
        }
        InputStream inputStream = null;
        DataInputStream dataInputStream = null;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<Integer> vector3 = new Vector<Integer>();
        Vector<Integer> vector4 = new Vector<Integer>();
        Vector<Integer> vector5 = new Vector<Integer>();
        Vector<Integer> vector6 = new Vector<Integer>();
        try {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("m" + this.missionNumberCurrent);
            dataInputStream = new DataInputStream(inputStream);
            int n14 = dataInputStream.read();
            while (true) {
                n11 = n14 >>> 4 & 0xF;
                n10 = n14 & 0xF;
                if (n11 > 1) break;
                n9 = dataInputStream.read();
                vector2.addElement(new Integer(n10));
                vector3.addElement(new Integer(n9));
                n14 = dataInputStream.read();
            }
            n8 = 3;
            n7 = vector2.size() - 1;
            while (n7 >= 0) {
                this.playerX[n8] = (Integer)vector2.elementAt(n7) << 4;
                this.playerY[n8] = (Integer)vector3.elementAt(n7) << 4;
                this.playerNextShot[n8] = 0;
                int n15 = this.missionNumberCurrent == 9 ? 2 : this.missionNumberCurrent / 3;
                this.playerHealth[n8] = n15 == 0 ? (byte)0 : (byte)(Math.abs(this.random.nextInt()) % (n15 + 1));
                this.playerDirection[n8] = 7;
                n8 = (byte)(n8 + 1);
                --n7;
            }
            this.playerArrayNext[n8 - 1] = -1;
            n6 = n8 - 2;
            while (n6 >= 0) {
                this.playerArrayNext[n6] = (byte)(n6 + 1);
                --n6;
            }
            this.opponentArrayStart = n8 > 3 ? (byte)3 : (byte)-1;
            vector2 = new Vector();
            vector3 = new Vector();
            while (n14 != 240) {
                n9 = dataInputStream.read();
                if (n11 == 7) {
                    this.screenImageLeft = (n10 << 4) + 8 - this.width / 2;
                    if (this.screenImageLeft < 0) {
                        this.screenImageLeft = 0;
                    } else if (this.screenImageLeft + this.width > 176) {
                        this.screenImageLeft = 176 - this.width;
                    }
                    this.currentPlayer = 0;
                    this.playerArrayStart = 0;
                    this.takeCover = false;
                    this.playerX[0] = n10 << 4;
                    this.playerY[0] = n9 << 4;
                    this.playerX[1] = n10 - 1 << 4;
                    this.playerY[1] = n9 + 1 << 4;
                    this.playerX[2] = n10 + 1 << 4;
                    this.playerY[2] = this.playerY[1];
                } else {
                    vector.addElement(new Integer(n11));
                    vector2.addElement(new Integer(n10));
                    vector3.addElement(new Integer(n9));
                }
                n14 = dataInputStream.read();
                n11 = n14 >>> 4 & 0xF;
                n10 = n14 & 0xF;
            }
            n14 = dataInputStream.read();
            while (true) {
                n11 = n14 >>> 2 & 0x3F;
                n10 = n14 & 3;
                if (n11 == 63) break;
                vector4.addElement(new Integer(n11 - 1));
                switch (n10) {
                    case 0: {
                        vector5.addElement(new Integer(4));
                        break;
                    }
                    case 1: {
                        vector5.addElement(new Integer(0));
                        break;
                    }
                    case 2: {
                        vector5.addElement(new Integer(2));
                        break;
                    }
                    case 3: {
                        vector5.addElement(new Integer(3));
                    }
                }
                vector6.addElement(new Integer(-1));
                n14 = dataInputStream.read();
            }
            int n16 = -1;
            int n17 = 0;
            n5 = 0;
            n4 = -1;
            n10 = 0;
            while (true) {
                if (n16 < 0) {
                    n17 = 0;
                    n3 = 2;
                    while (n3 >= 0) {
                        n14 = dataInputStream.read();
                        n17 += n14 << n3 * 8;
                        --n3;
                    }
                    n16 = 3;
                }
                if (n4 == -1) {
                    n4 = n17 >>> n16 * 6 & 0x3F;
                    if (n4 == 63) {
                        break;
                    }
                } else {
                    n14 = n17 >>> n16 * 6 & 0x3F;
                    if (n5 != 0) {
                        if (n14 == 0) {
                            this.MapData[n10 / 11][n10 % 11] = (byte)(n4 - 1);
                            ++n10;
                            break;
                        }
                        n3 = n14;
                        while (n3 > 0) {
                            this.MapData[n10 / 11][n10 % 11] = (byte)(n4 - 1);
                            ++n10;
                            --n3;
                        }
                        n5 = 0;
                        n4 = -1;
                    } else if (n14 == 63) {
                        n5 = 1;
                    } else {
                        this.MapData[n10 / 11][n10 % 11] = (byte)(n4 - 1);
                        ++n10;
                        n4 = n14;
                    }
                }
                --n16;
            }
            dataInputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.toString());
        }
        n8 = 0;
        int n18 = vector4.size();
        this.specialArrayExplodableStart = (byte)-1;
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        n3 = vector.size() - 1;
        while (n3 >= 0) {
            n11 = (Integer)vector.elementAt(n3);
            if (this.specialArrayExplodableStart < 0 && n11 <= 6) {
                this.specialArrayExplodableStart = (byte)n8;
            }
            switch (n11) {
                case 2: {
                    n7 = 4;
                    n6 = 1;
                    break;
                }
                case 3: {
                    n7 = 0;
                    n6 = 0;
                    break;
                }
                case 4: {
                    n7 = 1;
                    n6 = 0;
                    break;
                }
                case 5: {
                    n7 = 3;
                    n6 = 0;
                    break;
                }
                case 6: {
                    n7 = 2;
                    n6 = 0;
                    break;
                }
                case 8: {
                    n7 = 8;
                    n6 = 4;
                    break;
                }
                case 9: {
                    n7 = 6;
                    n6 = 4;
                    break;
                }
                case 10: {
                    n7 = 5;
                    n6 = 4;
                    break;
                }
                case 11: {
                    n7 = 7;
                    n6 = 4;
                    break;
                }
                case 12: {
                    n7 = 9;
                    n6 = 5;
                    break;
                }
                default: {
                    n7 = -1;
                    n6 = -1;
                }
            }
            if (n7 >= 0) {
                n10 = (Integer)vector2.elementAt(n3);
                n9 = (Integer)vector3.elementAt(n3);
                n5 = 0;
                n2 = (SPECIAL_GFX_W[n7] >> 4) - 1;
                while (n2 >= 0) {
                    n = (SPECIAL_GFX_H[n7] >> 4) - 1;
                    while (n >= 0) {
                        n4 = 0;
                        while (n4 < n5) {
                            if (byArray[n4] == this.MapData[n9 + n][n10 + n2]) {
                                this.MapData[n9 + n][n10 + n2] = byArray2[n4];
                                break;
                            }
                            n4 = (byte)(n4 + 1);
                        }
                        if (n4 == n5) {
                            byArray[n5] = this.MapData[n9 + n][n10 + n2];
                            byArray2[n5] = n18;
                            n5 = (byte)(n5 + 1);
                            vector4.addElement((Integer)vector4.elementAt(this.MapData[n9 + n][n10 + n2]));
                            vector5.addElement(new Integer(n6));
                            if (n6 == 5) {
                                vector6.addElement(new Integer(-1));
                            } else {
                                vector6.addElement(new Integer(n8));
                            }
                            this.MapData[n9 + n][n10 + n2] = n18;
                            n18 = (byte)(n18 + 1);
                        }
                        --n;
                    }
                    --n2;
                }
                if (n7 != 9) {
                    this.specialX[n8] = n10 << 4;
                    this.specialY[n8] = n9 << 4;
                    this.specialType[n8] = n7;
                    this.specialDamage[n8] = 2;
                    n8 = (byte)(n8 + 1);
                }
            }
            --n3;
        }
        this.TileTextureData = new byte[n18];
        this.TileBlockData = new byte[n18];
        this.TileSpecialData = new byte[n18];
        n2 = 0;
        while (n2 < n18) {
            this.TileTextureData[n2] = (byte)((Integer)vector4.elementAt(n2)).intValue();
            this.TileBlockData[n2] = (byte)((Integer)vector5.elementAt(n2)).intValue();
            this.TileSpecialData[n2] = (byte)((Integer)vector6.elementAt(n2)).intValue();
            ++n2;
        }
        if (n8 > 0) {
            this.specialArrayStart = 0;
            this.specialArrayNext[n8 - 1] = -1;
            this.specialArrayPrevious[0] = -1;
            if (n8 > 1) {
                n = n8 - 2;
                while (n >= 0) {
                    this.specialArrayNext[n] = (byte)(n + 1);
                    this.specialArrayPrevious[n + 1] = (byte)n;
                    --n;
                }
            }
        } else {
            this.specialArrayStart = (byte)-1;
        }
        this.playerAimY[1] = -1;
        this.playerAimY[0] = -1;
        this.playerAimX[1] = -1;
        this.playerAimX[0] = -1;
        n = Math.min(this.playerY[this.currentPlayer] + 16 + 55, 2048);
        this.screenImageTop = n - this.height;
        n = n + 15 >> 4 << 4;
        this.screenSplit = n - this.screenImageHeight;
        this.screenImageDiscontinuity = this.screenImageHeight;
        int n19 = n >> 4;
        int n20 = this.screenImageHeight >> 4;
        int n21 = n20 - 1;
        while (n21 >= 0) {
            --n19;
            int n22 = 10;
            while (n22 >= 0) {
                this.screenImageGraphics.setClip(n22 << 4, n21 << 4, 16, 16);
                byte by = this.TileTextureData[this.MapData[n19][n22]];
                if (by == 26) {
                    this.screenImageGraphics.drawImage(this.tilesImage, n22 - 0 << 4, n21 << 4, 20);
                } else if (by == 28) {
                    this.screenImageGraphics.setColor(0);
                    this.screenImageGraphics.fillRect(n22 << 4, n21 << 4, 16, 16);
                }
                this.screenImageGraphics.drawImage(this.tilesImage, n22 - by << 4, n21 << 4, 20);
                --n22;
            }
            --n21;
        }
    }

    public final void pause() {
        this.cod.notifyPaused();
    }

    private final void readRecords() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"cod", (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            recordStore.closeRecordStore();
            this.missionNumberMax = byArray[0];
            this.soundOn = byArray[1] > 0;
            int n = 0;
            while (n <= this.missionNumberMax) {
                this.missionTime[n] = 0;
                int n2 = 0;
                while (n2 < 4) {
                    this.missionTime[n] = (this.missionTime[n] << 8) + (byArray[2 + 4 * n + n2] & 0xFF);
                    ++n2;
                }
                ++n;
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            this.writeRecords();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void writeRecords() {
        try {
            byte[] byArray = new byte[4 * this.missionNumberMax + 6];
            byArray[0] = this.missionNumberMax;
            byArray[1] = (byte)(this.soundOn ? 1 : 0);
            int n = 0;
            while (n <= this.missionNumberMax) {
                int n2 = 0;
                while (n2 < 4) {
                    byArray[2 + 4 * n + n2] = (byte)(this.missionTime[n] >>> (3 - n2) * 8 & 0xFF);
                    ++n2;
                }
                ++n;
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)"cod", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void PlaySound(int n) {
        if (this.soundOn) {
            try {
                this.sound = new Sound(this.soundWAV, 5);
                this.sound.play(n);
            }
            catch (Exception exception) {
                System.out.println("Error starting sound - " + exception);
            }
        }
    }

    private void StopSound() {
        if (this.soundOn) {
            try {
                this.sound.stop();
                this.sound.release();
                this.sound = null;
            }
            catch (Exception exception) {
                System.out.println("Error stopping sound - " + exception);
            }
        }
    }

    public final void exitGame() {
        this.cod.exit();
    }

    public final void paint(Graphics graphics) {
        if (this.screenType == 2) {
            byte by;
            int n;
            int n2;
            byte by2;
            graphics.drawImage(this.screenImage, -this.screenImageLeft, this.screenSplit - this.screenImageTop, 20);
            graphics.drawImage(this.screenImage, -this.screenImageLeft, this.screenSplit - this.screenImageTop - this.screenImageHeight, 20);
            byte by3 = this.specialArrayStart;
            boolean bl = true;
            while (by3 >= 0) {
                by2 = this.specialType[by3];
                if (by2 < 0) {
                    n2 = this.specialY[by3] - this.screenImageTop + CRATER_DRAW_Y[by2 = (byte)(-1 - by2)];
                    if (n2 < this.height && n2 + CRATER_GFX_H[by2] >= 0) {
                        bl = false;
                        graphics.setClip(this.specialX[by3] - this.screenImageLeft, n2, (int)CRATER_GFX_W[by2], (int)CRATER_GFX_H[by2]);
                        graphics.drawImage(this.craterImage, this.specialX[by3] - this.screenImageLeft - CRATER_GFX_X[by2], n2 - CRATER_GFX_Y[by2], 20);
                        if (Math.abs(this.random.nextInt()) % 40 < 1) {
                            this.StartSmoke(this.specialX[by3] + Math.abs(this.random.nextInt()) % CRATER_GFX_W[by2], n2 + this.screenImageTop + Math.abs(this.random.nextInt()) % CRATER_GFX_H[by2]);
                        }
                    }
                } else if (by2 != 4) {
                    graphics.setClip(this.specialX[by3] - this.screenImageLeft, this.specialY[by3] - this.screenImageTop, (int)SPECIAL_GFX_W[by2], (int)SPECIAL_GFX_H[by2]);
                    if (by2 == 8) {
                        graphics.drawImage(this.specialImage, this.specialX[by3] - this.screenImageLeft - ((this.frameCount & 1) << 4) - 48, this.specialY[by3] - this.screenImageTop - 48, 20);
                    } else {
                        graphics.drawImage(this.specialImage, this.specialX[by3] - this.screenImageLeft - SPECIAL_GFX_X[by2], this.specialY[by3] - this.screenImageTop - SPECIAL_GFX_Y[by2], 20);
                    }
                }
                by3 = this.specialArrayNext[by3];
            }
            if (bl && Math.abs(this.random.nextInt()) % 40 < 1) {
                this.StartSmoke(Math.abs(this.random.nextInt()) % this.width, this.screenImageTop + Math.abs(this.random.nextInt()) % this.height);
            }
            by3 = this.projectileArrayUsedStart;
            while (by3 >= 0) {
                switch (this.projectileType[by3]) {
                    case 99: {
                        n = this.projectileX[by3] - this.screenImageLeft;
                        n2 = this.projectileY[by3] - this.screenImageTop;
                        by = this.projectileDirection[by3];
                        graphics.setClip(n - bulletClipDeltaX[by], n2 - bulletClipDeltaY[by], (int)bulletClipWidth[by], (int)bulletClipHeight[by]);
                        graphics.drawImage(this.specialImage, n - bulletImageDeltaX[by], n2 - bulletImageDeltaY[by], 20);
                        this.RedrawSceneryAbove(graphics, this.projectileX[by3] - bulletClipDeltaX[by], this.projectileY[by3] - bulletClipDeltaY[by], bulletClipWidth[by], bulletClipHeight[by], (byte)-1);
                        break;
                    }
                    case 2: {
                        n = this.projectileX[by3] - this.screenImageLeft - 8;
                        n2 = this.projectileY[by3] - this.screenImageTop - 8;
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(this.specialImage, n - ((this.frameCount & 1) << 4) - 48, n2 - 32, 20);
                    }
                }
                by3 = this.projectileArrayNext[by3];
            }
            this.squareMax = 0;
            by3 = this.playerArrayStart;
            Image image = this.unitImage;
            if (by3 == this.opponentArrayStart) {
                image = this.enemyImage;
            }
            while (by3 >= 0) {
                n2 = this.playerY[by3];
                if (n2 <= this.screenImageTop + this.height && n2 + 16 >= this.screenImageTop) {
                    n = this.playerX[by3];
                    graphics.setClip(n - this.screenImageLeft, n2 - this.screenImageTop, 16, 16);
                    if (this.playerHealth[by3] < 0) {
                        by = -this.playerHealth[by3];
                        if ((by & 1) == 1) {
                            if ((by = (byte)(by >> 1 & 7)) > 3) {
                                by = (byte)(by + 1);
                            }
                            graphics.drawImage(image, n - this.screenImageLeft - 16, n2 - this.screenImageTop - (by << 4), 20);
                        }
                    } else {
                        graphics.drawImage(image, n - this.screenImageLeft - (this.playerMoving[by3] ? this.frameCount >> 1 << 4 : 16), n2 - this.screenImageTop - (this.playerDirection[by3] << 4), 20);
                    }
                    this.RedrawSceneryAbove(graphics, n, n2, 15, 15, by3);
                    if (this.TileBlockData[this.MapData[n2 + 8 >> 4][n + 8 >> 4]] == 3) {
                        graphics.setClip(n - this.screenImageLeft, n2 - this.screenImageTop + 10, 16, 6);
                        graphics.drawImage(this.screenImage, -this.screenImageLeft, this.screenSplit - this.screenImageTop, 20);
                        graphics.drawImage(this.screenImage, -this.screenImageLeft, this.screenSplit - this.screenImageTop - this.screenImageHeight, 20);
                    }
                }
                if ((by3 = this.playerArrayNext[by3]) != this.opponentArrayStart) continue;
                image = this.enemyImage;
            }
            byte by4 = 0;
            while (by4 < this.squareMax) {
                graphics.setClip((this.squareCol[by4] << 4) - this.screenImageLeft, (this.squareRow[by4] << 4) - this.screenImageTop, 16, 16);
                by3 = this.squarePlayer[by4];
                if (by3 < 3) {
                    graphics.setColor(65280);
                } else {
                    graphics.setColor(0xFF0000);
                }
                graphics.fillRect(this.playerX[by3] - this.screenImageLeft + 5, this.playerY[by3] - this.screenImageTop + 5, 6, 6);
                by4 = (byte)(by4 + 1);
            }
            by3 = this.specialArrayExplodableStart;
            while (by3 >= 0) {
                by2 = this.specialType[by3];
                if (by2 == 4) {
                    graphics.setClip(this.specialX[by3] - this.screenImageLeft, this.specialY[by3] - this.screenImageTop, (int)SPECIAL_GFX_W[by2], (int)SPECIAL_GFX_H[by2]);
                    graphics.drawImage(this.specialImage, this.specialX[by3] - this.screenImageLeft - SPECIAL_GFX_X[by2], this.specialY[by3] - this.screenImageTop - SPECIAL_GFX_Y[by2], 20);
                }
                by3 = this.specialArrayNext[by3];
            }
            by3 = this.projectileArrayUsedStart;
            while (by3 >= 0) {
                switch (this.projectileType[by3]) {
                    case 0: {
                        n = this.projectileX[by3] - this.screenImageLeft - 3;
                        n2 = this.projectileY[by3] - this.screenImageTop - 5;
                        graphics.setClip(n, n2, 7, 10);
                        graphics.drawImage(this.specialImage, n - 1 - 64, n2, 20);
                        break;
                    }
                    case 1: {
                        n = this.projectileX[by3] - this.screenImageLeft - 2;
                        n2 = this.projectileY[by3] - this.screenImageTop - 2;
                        graphics.setClip(n, n2, 5, 5);
                        graphics.drawImage(this.specialImage, n - 74, n2 - 15, 20);
                        break;
                    }
                    case 10: {
                        n = this.projectileX[by3] - this.screenImageLeft - 16;
                        n2 = this.projectileY[by3] - this.screenImageTop - 16;
                        graphics.setClip(n, n2, 32, 32);
                        graphics.drawImage(this.explosionImage, n - (this.projectileTime[by3] << 5), n2, 20);
                        break;
                    }
                    case 11: {
                        n = this.projectileX[by3] - this.screenImageLeft - 16;
                        n2 = this.projectileY[by3] - this.screenImageTop - 16;
                        graphics.setClip(n, n2, 32, 32);
                        int n3 = (this.projectileTime[by3] >> 1) - 3;
                        if (n3 < 0) {
                            n3 = -n3;
                        }
                        graphics.drawImage(this.smokeImage, n - (n3 << 5), n2, 20);
                    }
                }
                by3 = this.projectileArrayNext[by3];
            }
            by3 = this.playerArrayStart;
            while (by3 != this.opponentArrayStart) {
                if (this.playerShowStatus[by3] > this.clockTicks && this.playerHealth[by3] >= 0) {
                    n = this.playerX[by3] - this.screenImageLeft;
                    n2 = this.playerY[by3] - this.screenImageTop;
                    graphics.setClip(n - 3, n2 + 16, 21, 7);
                    graphics.setColor(0);
                    graphics.fillRect(n - 3, n2 + 16, 21, 7);
                    graphics.setColor(0xFF0000);
                    graphics.fillRect(n + 5, n2 + 18, this.playerHealth[by3] * 4, 3);
                    graphics.setClip(n - 2, n2 + 17, 5, 5);
                    graphics.drawImage(this.symbolsImage, n - 2 - this.playerType[by3] * 5, n2 + 17, 20);
                    graphics.setClip(n + 4, n2 + 17, 13, 5);
                    if (by3 == this.currentPlayer) {
                        graphics.drawImage(this.symbolsImage, n - 35, n2 + 17, 20);
                    } else {
                        graphics.drawImage(this.symbolsImage, n - 22, n2 + 17, 20);
                    }
                }
                by3 = this.playerArrayNext[by3];
            }
            graphics.setClip(0, 0, this.width, this.height);
            graphics.drawImage(this.statusBar, 1, this.height - 14 - 1, 20);
            if (this.playerProtected[this.currentPlayer] > this.clockTicks) {
                graphics.setClip(67, this.height - 14 - 1, 12, 14);
                graphics.drawImage(this.symbolsImage, -15, this.height - 17, 20);
                graphics.setClip(0, 0, this.width, this.height);
            }
            if (this.showOrders > this.clockTicks) {
                graphics.setColor(0xFFFFFF);
                graphics.setFont(this.font);
                if (this.takeCover) {
                    graphics.drawString("Orders: Take Cover", this.width - 2, this.height - this.fontHeight, 24);
                } else {
                    graphics.drawString("Orders: Follow Me", this.width - 2, this.height - this.fontHeight, 24);
                }
            }
        } else {
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.width, this.height);
            graphics.drawImage(this.splashImage, this.halfWidth, this.halfHeight, 3);
            graphics.setColor(0xFFFFFF);
            graphics.setFont(this.largeFont);
            if (this.screenType >= 100) {
                graphics.drawString(Strings.helpTitles[this.screenType - 100], this.halfWidth, 4, 17);
                this.ShowButtons(graphics, null, "BACK");
                graphics.setFont(this.font);
                this.PrintTextStrings(graphics);
            } else {
                switch (this.screenType) {
                    case 0: {
                        if (this.frameCount != 2) break;
                        graphics.drawImage(this.titleImage, this.halfWidth, this.halfHeight, 3);
                        break;
                    }
                    case 1: {
                        graphics.drawImage(this.titleImage, this.halfWidth, 4, 17);
                        graphics.drawImage(this.menuImage, this.halfWidth, (int)this.menuGraphicHeight, 17);
                        int n = this.menuGraphicHeight + this.menuLineHeight * (this.menuSelection - this.menuStart);
                        graphics.setClip(4, n, 16, 16);
                        graphics.drawImage(this.unitImage, 4 - (this.frameCount << 4), n - 80, 20);
                        graphics.setClip(this.width - 4 - 16, n, 16, 16);
                        graphics.drawImage(this.unitImage, this.width - 4 - 16 - (this.frameCount << 4), n - 48, 20);
                        break;
                    }
                    case 3: {
                        graphics.drawString("Help", this.halfWidth, 4, 17);
                        this.ShowButtons(graphics, "SELECT", "BACK");
                        this.PrintMenuStrings(graphics);
                        break;
                    }
                    case 4: 
                    case 5: {
                        graphics.drawString("Options", this.halfWidth, 4, 17);
                        this.ShowButtons(graphics, "SELECT", "BACK");
                        this.PrintMenuStrings(graphics);
                        break;
                    }
                    case 13: {
                        graphics.drawString("Reset Game", this.halfWidth, 4, 17);
                        graphics.drawString("Are you sure?", this.halfWidth, this.halfHeight, 17);
                        this.ShowButtons(graphics, "CONFIRM", "BACK");
                        break;
                    }
                    case 6: {
                        graphics.drawImage(this.titleImage, this.halfWidth, 4, 17);
                        this.ShowButtons(graphics, "SELECT", "BACK");
                        this.PrintMenuStrings(graphics);
                        break;
                    }
                    case 7: 
                    case 8: {
                        graphics.drawString(Strings.missionTitle[this.missionNumberCurrent], this.halfWidth, 4, 17);
                        this.ShowButtons(graphics, "CONTINUE", this.screenType == 7 ? "BACK" : "MENU");
                        graphics.setFont(this.font);
                        this.PrintTextStrings(graphics);
                        break;
                    }
                    case 11: {
                        graphics.drawString(Strings.missionTitle[this.missionNumberCurrent], this.halfWidth, 4, 17);
                        if (this.missionNumberCurrent < 9) {
                            this.ShowButtons(graphics, "CONTINUE", "MENU");
                        } else {
                            this.ShowButtons(graphics, null, "MENU");
                        }
                        graphics.setFont(this.font);
                        this.PrintTextStrings(graphics);
                        break;
                    }
                    case 12: {
                        this.ShowButtons(graphics, "RESTART", "MENU");
                        graphics.drawString("All units killed", this.halfWidth, this.halfHeight, 17);
                        break;
                    }
                    case 9: {
                        int n = this.halfWidth - 22;
                        int n4 = 4 + this.largeFontHeight + 4;
                        int n5 = 0;
                        while (n5 < 3) {
                            graphics.setClip(n, n4, 12, 12);
                            if (this.playerType[n5] >= 0) {
                                graphics.drawImage(this.symbolsImage, n - 12 * this.playerType[n5], n4 - 5, 20);
                            } else {
                                graphics.drawImage(this.symbolsImage, n - 60, n4 - 5, 20);
                            }
                            n += 16;
                            ++n5;
                        }
                        n = this.halfWidth - 24;
                        graphics.setClip(n, n4 += 22, 48, 72);
                        graphics.drawImage(this.selectImage, n - 48 * this.frameCount, n4, 20);
                        graphics.setClip(n - 15, n4 + 32, 5, 9);
                        graphics.drawImage(this.arrowsImage, n - 15, n4 + 28, 20);
                        graphics.setClip(n + 58, n4 + 32, 5, 9);
                        graphics.drawImage(this.arrowsImage, n + 54, n4 + 28, 20);
                        graphics.setClip(0, 0, this.width, this.height);
                        graphics.drawString("Select Squad", this.halfWidth, 4, 17);
                        if (this.playerType[0] == this.frameCount || this.playerType[1] == this.frameCount || this.playerType[2] == this.frameCount) {
                            graphics.drawString("DESELECT", 4, this.height - 4 - this.largeFontHeight, 20);
                        } else if (this.playerType[0] < 0 || this.playerType[1] < 0 || this.playerType[2] < 0) {
                            graphics.drawString("SELECT", 4, this.height - 4 - this.largeFontHeight, 20);
                        }
                        if (this.playerType[0] >= 0 && this.playerType[1] >= 0 && this.playerType[2] >= 0) {
                            graphics.drawString("CONTINUE", this.width - 4, this.height - 4 - this.largeFontHeight, 24);
                        }
                        graphics.setFont(this.font);
                        n = this.halfWidth;
                        graphics.drawString(Strings.playerName[this.frameCount], n, n4 += 82, 17);
                        graphics.drawString("Armor: " + Strings.armourLevel[INITIAL_HEALTH[this.frameCount] - 1], n, n4 + this.fontHeight + 4, 17);
                        graphics.drawString("Special: " + Strings.playerSpecialName[this.frameCount], n, n4 + 2 * this.fontHeight + 4, 17);
                        break;
                    }
                    case 10: {
                        graphics.drawString("Select Squad", this.halfWidth, 4, 17);
                        this.ShowButtons(graphics, "CONFIRM", "CHANGE");
                        int n = 0;
                        while (n < 3) {
                            graphics.setClip(this.halfWidth - 80 + 54 * n, this.halfHeight - 24, 48, 72);
                            graphics.drawImage(this.selectImage, this.halfWidth - 80 + 54 * n - 48 * this.playerType[n], this.halfHeight - 24, 20);
                            ++n;
                        }
                        break;
                    }
                    case 14: {
                        graphics.drawImage(this.titleImage, this.halfWidth, 4, 17);
                        this.ShowButtons(graphics, "CONTINUE", null);
                        graphics.setFont(this.font);
                        this.PrintTextStrings(graphics);
                    }
                }
            }
        }
    }

    private void PrintMenuStrings(Graphics graphics) {
        int n = 0;
        while (n < this.menuLines) {
            graphics.drawString(this.menuStringArray[this.menuStart + n - 1], this.halfWidth, this.menuGraphicHeight + 1 + this.menuLineHeight * n, 17);
            ++n;
        }
        int n2 = this.menuGraphicHeight + this.menuLineHeight * (this.menuSelection - this.menuStart);
        graphics.setClip(4, n2, 16, 16);
        graphics.drawImage(this.unitImage, 4 - (this.frameCount << 4), n2 - 80, 20);
        graphics.setClip(this.width - 4 - 16, n2, 16, 16);
        graphics.drawImage(this.unitImage, this.width - 4 - 16 - (this.frameCount << 4), n2 - 48, 20);
        if (this.menuStart > 1 || this.menuStart + this.menuLines <= this.menuLength) {
            graphics.setClip(this.halfWidth - 3, this.height - 4 - 9, 7, 4);
            graphics.drawImage(this.arrowsImage, this.halfWidth - 4, this.height - 4 - (this.menuStart == 1 ? 9 : 13), 20);
            graphics.setClip(this.halfWidth - 3, this.height - 4 - 4, 7, 4);
            graphics.drawImage(this.arrowsImage, this.halfWidth - 4, this.height - 4 - (this.menuStart + this.menuLines > this.menuLength ? 17 : 13), 20);
        }
    }

    private void PrintTextStrings(Graphics graphics) {
        int n = 0;
        while (n < this.menuLines) {
            graphics.drawString(this.menuStringArray[this.menuStart + n - 1], 4, this.menuGraphicHeight + 1 + this.menuLineHeight * n, 20);
            ++n;
        }
        if (this.menuStart > 1 || this.menuStart + this.menuLines <= this.menuLength) {
            int n2 = this.menuLines * this.menuLineHeight;
            graphics.drawRect(this.width - 4 - 7, this.menuGraphicHeight + 5, 6, n2 - 11);
            if (this.menuLines >= this.menuLength) {
                graphics.fillRect(this.width - 4 - 5, this.menuGraphicHeight + 7, 3, n2 - 14);
            } else {
                graphics.fillRect(this.width - 4 - 5, this.menuGraphicHeight + (this.menuStart - 1) * (n2 - 14) / this.menuLength + 7, 3, this.menuLines * (n2 - 14) / this.menuLength);
            }
            graphics.setClip(this.width - 4 - 7, (int)this.menuGraphicHeight, 7, 4);
            graphics.drawImage(this.arrowsImage, this.width - 4 - 8, this.menuStart == 1 ? this.menuGraphicHeight : this.menuGraphicHeight - 4, 20);
            graphics.setClip(this.width - 4 - 7, this.menuGraphicHeight + n2 - 4, 7, 4);
            graphics.drawImage(this.arrowsImage, this.width - 4 - 8, this.menuGraphicHeight + n2 - (this.menuStart + this.menuLines > this.menuLength ? 17 : 13), 20);
        }
    }

    private void ShowButtons(Graphics graphics, String string, String string2) {
        if (string != null) {
            graphics.drawString(string, 4, this.height - 4 - this.largeFontHeight, 20);
        }
        if (string2 != null) {
            graphics.drawString(string2, this.width - 4, this.height - 4 - this.largeFontHeight, 24);
        }
    }

    private void CheckTextUpAndDown(int n) {
        if (n == 1 && this.menuStart > 1) {
            this.menuStart = (short)(this.menuStart - 1);
        } else if (n == 6 && this.menuStart + this.menuLines <= this.menuLength) {
            this.menuStart = (short)(this.menuStart + 1);
        }
    }

    private void CheckMenuUpAndDown(int n) {
        if (n == 1 && this.menuSelection > 1) {
            this.menuSelection = (short)(this.menuSelection - 1);
            if (this.menuSelection < this.menuStart) {
                this.menuStart = (short)(this.menuStart - 1);
            }
            this.repaint();
        } else if (n == 6 && this.menuSelection < this.menuLength) {
            this.menuSelection = (short)(this.menuSelection + 1);
            if (this.menuSelection >= this.menuStart + this.menuLines) {
                this.menuStart = (short)(this.menuStart + 1);
            }
            this.repaint();
        }
    }

    private void UpdateStatusBar() {
        Graphics graphics = this.statusBar.getGraphics();
        graphics.setColor(0);
        graphics.fillRect(0, 0, 66, 14);
        graphics.setClip(1, 1, 12, 12);
        graphics.drawImage(this.symbolsImage, 1 - 12 * this.playerType[this.currentPlayer], -4, 20);
        graphics.setClip(0, 0, 66, 14);
        int n = 0;
        while (n < 3) {
            graphics.setColor(0xFFFFFF);
            graphics.drawRect(14 + n * 9, 1, 9, 11);
            if (this.playerHealth[this.currentPlayer] > n) {
                graphics.setColor(0xFF0000);
                graphics.fillRect(15 + n * 9, 2, 8, 10);
            }
            ++n;
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(43, 1, 22, 12);
        if (this.playerType[this.currentPlayer] != 4 && this.playerType[this.currentPlayer] != 3) {
            graphics.setClip(43, 2, 10, 10);
            graphics.drawImage(this.specialImage, -21, 2 - 10 * WEAPON_TYPE[this.playerType[this.currentPlayer]], 20);
            graphics.setClip(0, 0, 66, 14);
            graphics.setColor(0);
            graphics.setFont(this.font);
            graphics.drawString("" + this.playerSpecial[this.currentPlayer], 64, 1, 24);
        }
    }

    private void SetInvisibility(byte by, boolean bl) {
        if (bl) {
            if (by == this.currentPlayer) {
                Graphics graphics = this.statusBar.getGraphics();
                graphics.setClip(43, 2, 10, 10);
                graphics.drawImage(this.symbolsImage, -29, -4, 20);
            }
            this.playerSpecial[by] = this.clockTicks + 180;
        } else {
            if (by == this.currentPlayer) {
                Graphics graphics = this.statusBar.getGraphics();
                graphics.setClip(43, 2, 10, 10);
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(43, 2, 10, 10);
            }
            this.playerSpecial[by] = 0;
        }
    }

    private void RedrawSceneryAbove(Graphics graphics, int n, int n2, int n3, int n4, byte by) {
        int n5 = n2 >> 4;
        while (n5 <= n2 + n4 >> 4) {
            if (n5 >= 0 && n5 < 128) {
                int n6 = n >> 4;
                while (n6 <= n + n3 >> 4) {
                    if (n6 >= 0 && n6 < 11 && this.TileBlockData[this.MapData[n5][n6]] == 2) {
                        graphics.setClip((n6 << 4) - this.screenImageLeft, (n5 << 4) - this.screenImageTop, 16, 16);
                        byte by2 = this.TileTextureData[this.MapData[n5][n6]];
                        graphics.drawImage(this.tilesImage, (n6 - by2 << 4) - this.screenImageLeft, (n5 << 4) - this.screenImageTop, 20);
                        if (by >= 0 && by2 != 28 && this.playerHealth[by] >= 0 && this.squareMax < 30) {
                            this.squarePlayer[this.squareMax] = by;
                            this.squareRow[this.squareMax] = (byte)n5;
                            this.squareCol[this.squareMax] = (byte)n6;
                            this.squareMax = (byte)(this.squareMax + 1);
                        }
                    }
                    ++n6;
                }
            }
            ++n5;
        }
    }

    protected void keyPressed(int n) {
        if (this.screenType == 2) {
            this.nextKeyCode = n;
        } else {
            int n2 = this.getGameAction(n);
            if (this.screenType >= 100) {
                if (n == -7) {
                    short s = (short)(this.screenType - 99);
                    this.SetMenuScreenType((short)3);
                    this.StartSimpleTimer((short)2, 100);
                    this.SetMenuSelection(s);
                } else {
                    this.CheckTextUpAndDown(n2);
                }
            } else {
                switch (this.screenType) {
                    case 0: {
                        this.simpletimertask.cancel();
                        if (this.frameCount < 2) {
                            this.splashImage = this.GetImage("backdrop");
                        }
                        this.GetSound("background");
                        this.GoToMainMenu(true);
                        break;
                    }
                    case 1: {
                        if (n == -6 || n2 == 8) {
                            switch (this.menuSelection) {
                                case 1: {
                                    if (this.missionNumberMax > 0) {
                                        this.SetMenuScreenType((short)6);
                                        break;
                                    }
                                    this.simpletimertask.cancel();
                                    this.splashImage = this.GetImage("brief");
                                    this.missionNumberCurrent = 0;
                                    this.SetMenuScreenType((short)7);
                                    break;
                                }
                                case 2: {
                                    this.SetMenuScreenType((short)4);
                                    break;
                                }
                                case 3: {
                                    this.SetMenuScreenType((short)3);
                                    break;
                                }
                                case 4: {
                                    this.simpletimertask.cancel();
                                    this.SetMenuScreenType((short)14);
                                }
                            }
                            break;
                        }
                        this.CheckMenuUpAndDown(n2);
                        break;
                    }
                    case 3: {
                        if (n == -6 || n2 == 8) {
                            this.simpletimertask.cancel();
                            this.SetMenuScreenType((short)(99 + this.menuSelection));
                            break;
                        }
                        if (n == -7) {
                            this.GoToMainMenu(false);
                            this.SetMenuSelection((short)3);
                            break;
                        }
                        if (n == 49) {
                            if (this.clockTicks != 0) break;
                            ++this.clockTicks;
                            break;
                        }
                        if (n == 51) {
                            if (this.clockTicks == 2) {
                                ++this.clockTicks;
                                break;
                            }
                            this.clockTicks = 0;
                            break;
                        }
                        if (n == 57) {
                            if (this.clockTicks == 1) {
                                ++this.clockTicks;
                                break;
                            }
                            if (this.clockTicks == 3) {
                                this.missionNumberMax = (byte)9;
                                this.writeRecords();
                                break;
                            }
                            this.clockTicks = 0;
                            break;
                        }
                        this.CheckMenuUpAndDown(n2);
                        break;
                    }
                    case 4: {
                        if (n == -6 || n2 == 8) {
                            switch (this.menuSelection) {
                                case 1: {
                                    this.soundOn = !this.soundOn;
                                    this.menuStringArray[0] = this.soundOn ? "Sound: ON" : "Sound: OFF";
                                    this.writeRecords();
                                    break;
                                }
                                case 2: {
                                    this.simpletimertask.cancel();
                                    this.screenType = (short)13;
                                }
                            }
                            break;
                        }
                        if (n == -7) {
                            this.GoToMainMenu(false);
                            this.SetMenuSelection((short)2);
                            break;
                        }
                        this.CheckMenuUpAndDown(n2);
                        break;
                    }
                    case 13: {
                        if (n == -6 || n2 == 8) {
                            this.missionNumberMax = 0;
                            this.missionNumberCurrent = 0;
                            int n3 = 0;
                            while (n3 <= 9) {
                                this.missionTime[n3] = 0;
                                ++n3;
                            }
                            this.writeRecords();
                            this.GoToMainMenu(true);
                            break;
                        }
                        if (n != -7) break;
                        this.StartSimpleTimer((short)2, 100);
                        this.screenType = (short)4;
                        break;
                    }
                    case 5: {
                        if (n == -6 || n2 == 8) {
                            switch (this.menuSelection) {
                                case 1: {
                                    this.soundOn = !this.soundOn;
                                    this.menuStringArray[0] = this.soundOn ? "Sound: ON" : "Sound: OFF";
                                    this.writeRecords();
                                    break;
                                }
                                case 2: {
                                    this.simpletimertask.cancel();
                                    this.screenType = (short)10;
                                    break;
                                }
                                case 3: {
                                    this.GoToMainMenu(false);
                                }
                            }
                            break;
                        }
                        if (n == -7) {
                            this.simpletimertask.cancel();
                            this.PlaySound(0);
                            this.frameCount = 0;
                            this.StartSimpleTimer((short)0, 50);
                            this.screenType = (short)2;
                            break;
                        }
                        this.CheckMenuUpAndDown(n2);
                        break;
                    }
                    case 6: {
                        if (n == -6 || n2 == 8) {
                            this.simpletimertask.cancel();
                            this.missionNumberCurrent = (byte)(this.missionNumberMax - this.menuSelection + 1);
                            this.splashImage = this.GetImage("brief");
                            this.SetMenuScreenType((short)7);
                            break;
                        }
                        if (n == -7) {
                            this.GoToMainMenu(false);
                            break;
                        }
                        this.CheckMenuUpAndDown(n2);
                        break;
                    }
                    case 7: 
                    case 8: {
                        if (n == -6 || n2 == 8) {
                            this.splashImage = this.GetImage("backdrop");
                            this.playerType[2] = -1;
                            this.playerType[1] = -1;
                            this.playerType[0] = -1;
                            this.frameCount = 0;
                            this.screenType = (short)9;
                            break;
                        }
                        if (n == -7) {
                            if (this.screenType == 8 || this.missionNumberMax == 0) {
                                this.GoToMainMenu(true);
                                break;
                            }
                            this.StartSimpleTimer((short)2, 100);
                            this.SetMenuScreenType((short)6);
                            break;
                        }
                        this.CheckTextUpAndDown(n2);
                        break;
                    }
                    case 9: {
                        if (n == -6 || n2 == 8) {
                            int n4 = -1;
                            int n5 = -1;
                            int n6 = 0;
                            while (n6 < 3) {
                                if (this.playerType[n6] < 0 && n4 < 0) {
                                    n4 = n6;
                                }
                                if (this.playerType[n6] == this.frameCount) {
                                    n5 = n6;
                                    break;
                                }
                                ++n6;
                            }
                            if (n5 >= 0) {
                                this.playerType[n5] = -1;
                                while (n5 < 2) {
                                    this.playerType[n5] = this.playerType[n5 + 1];
                                    this.playerType[n5 + 1] = -1;
                                    ++n5;
                                }
                                break;
                            }
                            if (n4 < 0) break;
                            this.playerType[n4] = this.frameCount;
                            this.frameCount = (byte)((this.frameCount + 1) % 5);
                            break;
                        }
                        if (n == -7 && this.playerType[0] >= 0 && this.playerType[1] >= 0 && this.playerType[2] >= 0) {
                            this.screenType = (short)10;
                            break;
                        }
                        if (n2 == 2 || n2 == 1) {
                            this.frameCount = (byte)(this.frameCount - 1);
                            if (this.frameCount >= 0) break;
                            this.frameCount = (byte)4;
                            break;
                        }
                        if (n2 != 5 && n2 != 6) break;
                        this.frameCount = (byte)((this.frameCount + 1) % 5);
                        break;
                    }
                    case 10: {
                        if (n == -6 || n2 == 8) {
                            this.ReadMap();
                            System.gc();
                            this.frameCount = 0;
                            this.showOrders = 0;
                            this.UpdateStatusBar();
                            this.clockTicks = 0;
                            this.endLevel = false;
                            this.PlaySound(0);
                            this.screenType = (short)2;
                            this.startTime = System.currentTimeMillis();
                            this.StartSimpleTimer((short)0, 50);
                            break;
                        }
                        if (n != -7) break;
                        this.frameCount = 0;
                        this.screenType = (short)9;
                        break;
                    }
                    case 11: {
                        if ((n == -6 || n2 == 8) && this.missionNumberCurrent < 9) {
                            this.missionNumberCurrent = (byte)(this.missionNumberCurrent + 1);
                            this.SetMenuScreenType((short)8);
                            break;
                        }
                        if (n == -7) {
                            if (this.missionNumberCurrent == 9) {
                                this.splashImage = this.GetImage("backdrop");
                            }
                            this.GoToMainMenu(true);
                            break;
                        }
                        this.CheckTextUpAndDown(n2);
                        break;
                    }
                    case 12: {
                        if (n == -6 || n2 == 8) {
                            this.splashImage = this.GetImage("backdrop");
                            this.screenType = (short)10;
                            break;
                        }
                        if (n != -7) break;
                        this.splashImage = this.GetImage("backdrop");
                        this.GoToMainMenu(true);
                        break;
                    }
                    case 14: {
                        if (n == -6 || n2 == 8) {
                            this.cod.midletExit();
                            break;
                        }
                        this.CheckTextUpAndDown(n2);
                    }
                }
            }
            this.repaint();
        }
    }

    private void GoToMainMenu(boolean bl) {
        this.SetMenuScreenType((short)1);
        this.frameCount = 0;
        if (bl) {
            this.StartSimpleTimer((short)2, 100);
        }
    }

    private void SetMenuSelection(short s) {
        this.menuStart = 1;
        this.menuSelection = s;
        if (this.menuSelection >= this.menuStart + this.menuLines) {
            this.menuStart = (short)(this.menuSelection - this.menuLines + 1);
        }
    }

    protected void keyReleased(int n) {
        if (this.nextKeyCode == n) {
            this.nextKeyCode = 0;
        }
    }

    private void StartSimpleTimer(short s, int n) {
        this.simpletimertask = new SimpleTimerTask(this, s);
        this.timer.schedule((TimerTask)this.simpletimertask, n);
    }

    public void SimpleTimerEndEvent(short s) {
        if (s == 0) {
            boolean bl;
            byte by;
            byte by2;
            int n;
            int n2;
            byte by3;
            int n3;
            int n4;
            int n5;
            int n6;
            ++this.clockTicks;
            this.frameCount = this.frameCount == 5 ? (byte)0 : (byte)(this.frameCount + 1);
            this.currentKeyCode = this.nextKeyCode;
            int n7 = -1;
            byte by4 = this.playerArrayStart;
            while (by4 >= 0) {
                if (this.playerHealth[by4] < 0) {
                    byte by5 = by4;
                    this.playerHealth[by5] = (byte)(this.playerHealth[by5] - 1);
                    if (this.playerHealth[by4] + 30 < 0) {
                        if (n7 >= 0) {
                            this.playerArrayNext[n7] = this.playerArrayNext[by4];
                        } else {
                            this.playerArrayStart = this.playerArrayNext[by4];
                            if (this.playerArrayStart == this.opponentArrayStart) {
                                this.StopSound();
                                this.splashImage = this.GetImage("lose");
                                this.screenType = (short)12;
                                this.allowKeyPresses = false;
                                this.StartSimpleTimer((short)3, 750);
                                this.repaint();
                                return;
                            }
                        }
                        if (by4 == this.opponentArrayStart) {
                            this.opponentArrayStart = this.playerArrayNext[by4];
                        }
                    } else {
                        n7 = by4;
                    }
                } else {
                    n7 = by4;
                }
                by4 = this.playerArrayNext[by4];
            }
            by4 = this.playerArrayStart;
            while (by4 != this.opponentArrayStart) {
                if (this.playerType[by4] == 3 && this.clockTicks == this.playerSpecial[by4]) {
                    this.SetInvisibility(by4, false);
                }
                by4 = this.playerArrayNext[by4];
            }
            int n8 = -1;
            byte by6 = this.projectileArrayUsedStart;
            while (by6 >= 0) {
                boolean bl2 = false;
                byte by7 = this.projectileDirection[by6];
                byte by8 = by6;
                this.projectileTime[by8] = (byte)(this.projectileTime[by8] + 1);
                byte by9 = this.projectileArrayNext[by6];
                switch (this.projectileType[by6]) {
                    case 99: {
                        if (this.projectileTime[by6] > 16) {
                            bl2 = true;
                            break;
                        }
                        byte by10 = by6;
                        this.projectileX[by10] = this.projectileX[by10] + bulletDeltaX[by7];
                        byte by11 = by6;
                        this.projectileY[by11] = this.projectileY[by11] + bulletDeltaY[by7];
                        n6 = this.projectileX[by6] + bulletEndDeltaX[by7];
                        n5 = this.projectileY[by6] + bulletEndDeltaY[by7];
                        if (n6 < 0 || n6 >= 176 || n5 < 0 || n5 >= 2048 || this.TileBlockData[this.MapData[n5 >> 4][n6 >> 4]] <= 1) {
                            bl2 = true;
                            break;
                        }
                        bl2 = this.CheckPlayerDamage(n6, n6 - 16, n5, n5 - 16, (byte)1);
                        break;
                    }
                    case 1: {
                        if (this.projectileTime[by6] <= 2) break;
                        bl2 = true;
                        break;
                    }
                    case 0: {
                        if (this.projectileTime[by6] > 8) {
                            this.DoExplosion(by6, 1);
                            break;
                        }
                        byte by12 = by6;
                        this.projectileX[by12] = this.projectileX[by12] + bulletDeltaX[by7];
                        byte by13 = by6;
                        this.projectileY[by13] = this.projectileY[by13] + bulletDeltaY[by7];
                        n6 = this.projectileX[by6];
                        n5 = this.projectileY[by6];
                        if (n6 >= -3 && n6 <= 179 && n5 >= -4 && n5 <= 2053) break;
                        bl2 = true;
                        break;
                    }
                    case 2: {
                        if (this.projectileTime[by6] <= 38) break;
                        this.DoExplosion(by6, 2);
                        break;
                    }
                    case 10: {
                        if (this.projectileTime[by6] <= 4) break;
                        bl2 = true;
                        break;
                    }
                    case 11: {
                        if (this.projectileTime[by6] > 14) {
                            bl2 = true;
                            break;
                        }
                        byte by14 = by6;
                        this.projectileX[by14] = this.projectileX[by14] + bulletDeltaX[by7];
                        byte by15 = by6;
                        this.projectileY[by15] = this.projectileY[by15] + bulletDeltaY[by7];
                    }
                }
                if (bl2) {
                    if (n8 >= 0) {
                        this.projectileArrayNext[n8] = by9;
                    } else {
                        this.projectileArrayUsedStart = by9;
                    }
                    this.projectileArrayNext[by6] = this.projectileArrayUnusedStart;
                    this.projectileArrayUnusedStart = by6;
                } else {
                    n8 = by6;
                }
                by6 = by9;
            }
            this.playerMoving[this.currentPlayer] = false;
            if (this.currentKeyCode != 0) {
                n4 = this.getGameAction(this.currentKeyCode);
                if (n4 == 8 && this.currentKeyCode != 35 || this.currentKeyCode == 53) {
                    this.StartProjectile(this.currentPlayer, (byte)99);
                    if (this.playerType[this.currentPlayer] == 3 && this.clockTicks < this.playerSpecial[this.currentPlayer]) {
                        this.SetInvisibility(this.currentPlayer, false);
                    }
                    this.nextKeyCode = 0;
                } else if (this.currentKeyCode == 42) {
                    n3 = this.playerType[this.currentPlayer];
                    if (n3 == 3 && this.clockTicks < this.playerSpecial[this.currentPlayer]) {
                        n6 = this.playerX[this.currentPlayer];
                        n5 = this.playerY[this.currentPlayer];
                        by4 = this.opponentArrayStart;
                        while (by4 >= 0) {
                            if (this.playerHealth[by4] >= 0 && this.playerX[by4] <= n6 + 16 && this.playerX[by4] >= n6 - 16 && this.playerY[by4] <= n5 + 16 && this.playerY[by4] >= n5 - 16) {
                                this.playerHealth[by4] = -1;
                            }
                            by4 = this.playerArrayNext[by4];
                        }
                        this.nextKeyCode = 0;
                    } else if (this.clockTicks > this.playerNextShot[this.currentPlayer] && this.playerSpecial[this.currentPlayer] > 0) {
                        byte by16 = this.currentPlayer;
                        this.playerSpecial[by16] = this.playerSpecial[by16] - 1;
                        this.UpdateStatusBar();
                        switch (n3) {
                            case 0: {
                                this.StartProjectile(this.currentPlayer, (byte)0);
                                this.playerNextShot[this.currentPlayer] = this.clockTicks + 10;
                                break;
                            }
                            case 1: {
                                this.StartProjectile(this.currentPlayer, (byte)1);
                                this.playerNextShot[this.currentPlayer] = this.clockTicks + 10;
                                break;
                            }
                            case 2: {
                                this.StartProjectile(this.currentPlayer, (byte)2);
                                this.playerNextShot[this.currentPlayer] = this.clockTicks + 10;
                            }
                        }
                    }
                } else {
                    if (this.currentKeyCode == -7) {
                        this.StopSound();
                        this.SetMenuScreenType((short)5);
                        this.frameCount = 0;
                        this.StartSimpleTimer((short)2, 100);
                        this.repaint();
                        return;
                    }
                    if (this.currentKeyCode == 35) {
                        this.currentPlayer = this.NextUnit(this.currentPlayer);
                        this.playerDirection[this.currentPlayer] = 1;
                        this.nextKeyCode = 0;
                        if (this.playerType[this.currentPlayer] == 4) {
                            this.takeCover = true;
                            this.showOrders = this.clockTicks + 50;
                        }
                        if (this.takeCover) {
                            this.SetHidingAims(this.currentPlayer);
                        }
                        this.UpdateStatusBar();
                        by4 = this.playerArrayStart;
                        while (by4 != this.opponentArrayStart) {
                            this.playerShowStatus[by4] = this.clockTicks + 60;
                            by4 = this.playerArrayNext[by4];
                        }
                    } else if (this.currentKeyCode == this.CHANGE_ORDERS) {
                        boolean bl3 = this.takeCover = !this.takeCover;
                        if (this.takeCover) {
                            this.SetHidingAims(this.currentPlayer);
                        } else {
                            this.playerAimY[1] = -1;
                            this.playerAimY[0] = -1;
                            this.playerAimX[1] = -1;
                            this.playerAimX[0] = -1;
                        }
                        this.showOrders = this.clockTicks + 50;
                        this.nextKeyCode = 0;
                    } else {
                        by3 = 4;
                        if (this.is3650) {
                            block13 : switch (this.currentKeyCode) {
                                case 48: 
                                case 57: {
                                    by3 = 2;
                                    break;
                                }
                                case 49: 
                                case 50: {
                                    by3 = 0;
                                    break;
                                }
                                case 51: 
                                case 52: {
                                    by3 = 6;
                                    break;
                                }
                                case 55: 
                                case 56: {
                                    by3 = 8;
                                    break;
                                }
                                default: {
                                    switch (n4) {
                                        case 1: {
                                            by3 = 1;
                                            break block13;
                                        }
                                        case 2: {
                                            by3 = 3;
                                            break block13;
                                        }
                                        case 5: {
                                            by3 = 5;
                                            break block13;
                                        }
                                        case 6: {
                                            by3 = 7;
                                        }
                                    }
                                    break;
                                }
                            }
                        } else {
                            switch (n4) {
                                case 1: {
                                    by3 = 1;
                                    break;
                                }
                                case 2: {
                                    by3 = 3;
                                    break;
                                }
                                case 5: {
                                    by3 = 5;
                                    break;
                                }
                                case 6: {
                                    by3 = 7;
                                    break;
                                }
                                default: {
                                    if (this.currentKeyCode < 49 || this.currentKeyCode > 57) break;
                                    by3 = (byte)(this.currentKeyCode - 49);
                                }
                            }
                        }
                        if (by3 != 4) {
                            this.playerDirection[this.currentPlayer] = by3;
                            int n9 = n2 = this.TileBlockData[this.MapData[this.playerY[this.currentPlayer] + 8 >> 4][this.playerX[this.currentPlayer] + 8 >> 4]] == 3 ? 1 : 2;
                            if (by3 < 3) {
                                n = this.MovePlayerUp(this.currentPlayer, n2);
                                if (n > 0) {
                                    byte by17 = this.currentPlayer;
                                    this.playerY[by17] = this.playerY[by17] - n;
                                } else {
                                    by3 = (byte)(by3 + 3);
                                }
                            } else if (by3 > 5) {
                                n = this.MovePlayerDown(this.currentPlayer, n2);
                                if (n > 0) {
                                    byte by18 = this.currentPlayer;
                                    this.playerY[by18] = this.playerY[by18] + n;
                                } else {
                                    by3 = (byte)(by3 - 3);
                                }
                            }
                            if (by3 % 3 == 0) {
                                n = this.MovePlayerLeft(this.currentPlayer, n2);
                                if (n > 0) {
                                    byte by19 = this.currentPlayer;
                                    this.playerX[by19] = this.playerX[by19] - n;
                                } else {
                                    by3 = (byte)(by3 + 1);
                                }
                            } else if (by3 % 3 == 2) {
                                n = this.MovePlayerRight(this.currentPlayer, n2);
                                if (n > 0) {
                                    byte by20 = this.currentPlayer;
                                    this.playerX[by20] = this.playerX[by20] + n;
                                } else {
                                    by3 = (byte)(by3 - 1);
                                }
                            }
                        }
                        if (by3 != 4) {
                            this.playerMoving[this.currentPlayer] = true;
                        }
                        if (this.endLevel) {
                            if (this.missionNumberCurrent == this.missionNumberMax && this.missionNumberMax < 9) {
                                this.missionNumberMax = (byte)(this.missionNumberMax + 1);
                                this.writeRecords();
                            }
                            this.StopSound();
                            if (this.missionNumberCurrent == 9) {
                                this.splashImage = this.GetImage("end");
                            }
                            this.SetMenuScreenType((short)11);
                            this.allowKeyPresses = false;
                            this.StartSimpleTimer((short)3, 750);
                            this.repaint();
                            return;
                        }
                    }
                }
            }
            if (this.playerDirection[this.currentPlayer] < 3) {
                n5 = this.screenImageTop + this.height - this.playerY[this.currentPlayer] - 16 - 55;
                if (n5 > 0) {
                    this.MoveScreenUp(n5);
                } else if (n5 < 0) {
                    this.MoveScreenDown(-n5);
                }
            } else if (this.playerDirection[this.currentPlayer] > 5) {
                n5 = this.playerY[this.currentPlayer] - this.screenImageTop - 55;
                if (n5 > 0) {
                    this.MoveScreenDown(n5);
                } else if (n5 < 0) {
                    this.MoveScreenUp(-n5);
                }
            }
            by4 = this.NextUnit(this.currentPlayer);
            n4 = 0;
            n3 = 0;
            byte by21 = 0;
            boolean bl4 = false;
            while (by4 != this.currentPlayer) {
                if (this.playerHealth[by4] >= 0) {
                    by2 = this.playerDirection[by4];
                    boolean bl5 = true;
                    if (this.playerY[by4] >= this.screenImageTop && this.playerY[by4] <= this.screenImageTop + this.height - 16 && this.playerX[by4] >= this.screenImageLeft && this.playerX[by4] <= this.screenImageLeft + this.width - 16) {
                        by = this.opponentArrayStart;
                        bl = by >= 0;
                        while (bl) {
                            if (this.playerHealth[by] >= 0 && this.playerY[by] >= this.screenImageTop && this.playerY[by] <= this.screenImageTop + this.height - 16 && this.playerX[by] >= this.screenImageLeft && this.playerX[by] <= this.screenImageLeft + this.width - 16 && this.TargetAhead(by2, n6 = this.playerX[by] - this.playerX[by4], n5 = this.playerY[by] - this.playerY[by4]) && this.ClearView(this.playerX[by4] + 8, this.playerY[by4] + 8, n6, n5)) {
                                by3 = this.GetDirection(n6, n5);
                                byte by22 = this.NextUnit(by4);
                                boolean bl6 = true;
                                while (bl6 && by22 != by4) {
                                    n6 = this.playerX[by22] - this.playerX[by4];
                                    n5 = this.playerY[by22] - this.playerY[by4];
                                    switch (by3) {
                                        case 0: {
                                            bl6 = n6 > 0 || n5 > n6 + 8 || n5 < n6 - 8;
                                            break;
                                        }
                                        case 1: {
                                            bl6 = n5 > 0 || n6 > 8 || n6 < -8;
                                            break;
                                        }
                                        case 2: {
                                            bl6 = n6 < 0 || n6 + n5 > 8 || n6 + n5 < -8;
                                            break;
                                        }
                                        case 3: {
                                            bl6 = n6 > 0 || n5 > 8 || n5 < -8;
                                            break;
                                        }
                                        case 5: {
                                            bl6 = n6 < 0 || n5 > 8 || n5 < -8;
                                            break;
                                        }
                                        case 6: {
                                            bl6 = n6 > 0 || n6 + n5 > 8 || n6 + n5 < -8;
                                            break;
                                        }
                                        case 7: {
                                            bl6 = n5 < 0 || n6 > 8 || n6 < -8;
                                            break;
                                        }
                                        case 8: {
                                            bl6 = n6 < 0 || n5 > n6 + 8 || n5 < n6 - 8;
                                        }
                                    }
                                    by22 = this.NextUnit(by22);
                                }
                                if (bl6) {
                                    if (this.clockTicks <= this.playerNextShot[by4]) break;
                                    this.playerDirection[by4] = by3;
                                    this.StartProjectile(by4, (byte)99);
                                    this.playerNextShot[by4] = this.clockTicks + 10;
                                    bl5 = false;
                                    break;
                                }
                            }
                            if ((by = this.playerArrayNext[by]) >= 0) continue;
                            bl = false;
                        }
                    }
                    if (bl5) {
                        int n10 = n2 = this.TileBlockData[this.MapData[this.playerY[by4] + 8 >> 4][this.playerX[by4] + 8 >> 4]] == 3 ? 1 : 2;
                        if (by21 == 0) {
                            if (this.playerAimX[0] >= 0) {
                                n4 = this.playerAimX[0];
                                n3 = this.playerAimY[0];
                            } else if (this.takeCover) {
                                n4 = this.playerX[by4];
                                n3 = this.playerY[by4];
                            } else if (this.playerDirection[this.currentPlayer] == 3) {
                                n4 = this.playerX[this.currentPlayer] + 16;
                                n3 = this.playerY[this.currentPlayer] + 16;
                            } else if (this.playerDirection[this.currentPlayer] == 5) {
                                n4 = this.playerX[this.currentPlayer] - 16;
                                n3 = this.playerY[this.currentPlayer] - 16;
                            } else if (this.playerDirection[this.currentPlayer] < 3) {
                                n4 = this.playerX[this.currentPlayer] - 16;
                                n3 = this.playerY[this.currentPlayer] + 16;
                            } else {
                                n4 = this.playerX[this.currentPlayer] + 16;
                                n3 = this.playerY[this.currentPlayer] - 16;
                            }
                        } else if (this.playerAimX[1] >= 0) {
                            n4 = this.playerAimX[1];
                            n3 = this.playerAimY[1];
                        } else if (this.takeCover) {
                            n4 = this.playerX[by4];
                            n3 = this.playerY[by4];
                        } else if (this.playerDirection[this.currentPlayer] == 3) {
                            n4 = this.playerX[this.currentPlayer] + 16;
                            n3 = this.playerY[this.currentPlayer] - 16;
                        } else if (this.playerDirection[this.currentPlayer] == 5) {
                            n4 = this.playerX[this.currentPlayer] - 16;
                            n3 = this.playerY[this.currentPlayer] + 16;
                        } else if (this.playerDirection[this.currentPlayer] < 3) {
                            n4 = this.playerX[this.currentPlayer] + 16;
                            n3 = this.playerY[this.currentPlayer] + 16;
                        } else {
                            n4 = this.playerX[this.currentPlayer] - 16;
                            n3 = this.playerY[this.currentPlayer] - 16;
                        }
                        by3 = 4;
                        if (n3 < this.playerY[by4]) {
                            n = this.MovePlayerUp(by4, Math.min(n2, this.playerY[by4] - n3));
                            if (n > 0) {
                                by3 = (byte)(by3 - 3);
                                byte by23 = by4;
                                this.playerY[by23] = this.playerY[by23] - n;
                            }
                        } else if (n3 > this.playerY[by4] && (n = this.MovePlayerDown(by4, Math.min(n2, n3 - this.playerY[by4]))) > 0) {
                            by3 = (byte)(by3 + 3);
                            byte by24 = by4;
                            this.playerY[by24] = this.playerY[by24] + n;
                        }
                        if (n4 < this.playerX[by4]) {
                            n = this.MovePlayerLeft(by4, Math.min(n2, this.playerX[by4] - n4));
                            if (n > 0) {
                                by3 = (byte)(by3 - 1);
                                byte by25 = by4;
                                this.playerX[by25] = this.playerX[by25] - n;
                            }
                        } else if (n4 > this.playerX[by4] && (n = this.MovePlayerRight(by4, Math.min(n2, n4 - this.playerX[by4]))) > 0) {
                            by3 = (byte)(by3 + 1);
                            byte by26 = by4;
                            this.playerX[by26] = this.playerX[by26] + n;
                        }
                        if (by3 == 4) {
                            if (this.takeCover) {
                                this.playerDirection[by4] = 1;
                            } else {
                                this.playerDirection[by4] = this.playerDirection[this.currentPlayer];
                                if (n4 == this.playerX[by4] && n3 == this.playerY[by4]) {
                                    this.playerAimY[by21] = -1;
                                    this.playerAimX[by21] = -1;
                                } else if (bl4 && by21 == 1 && this.playerAimX[1] >= 0) {
                                    this.playerAimY[1] = -1;
                                    this.playerAimY[0] = -1;
                                    this.playerAimX[1] = -1;
                                    this.playerAimX[0] = -1;
                                } else {
                                    bl4 = this.playerAimX[by21] >= 0;
                                    n6 = this.playerX[by4];
                                    n5 = this.playerY[by4];
                                    if (n3 < n5 - 16 && n5 >= 16) {
                                        if ((n5 & 0xF) == 0) {
                                            this.SetAvoidanceAimUpAndDown(n6 >> 4, n5 >> 4, -1, by21);
                                        }
                                    } else if (n4 < n6 - 16 && n6 >= 16) {
                                        if ((n6 & 0xF) == 0) {
                                            this.SetAvoidanceAimLeftAndRight(n6 >> 4, n5 >> 4, -1, by21);
                                        }
                                    } else if (n4 > n6 + 16 && n6 <= 144) {
                                        if ((n6 & 0xF) == 0) {
                                            this.SetAvoidanceAimLeftAndRight(n6 >> 4, n5 >> 4, 1, by21);
                                        }
                                    } else if (n3 > n5 + 16 && n5 <= 2016 && (n5 & 0xF) == 0) {
                                        this.SetAvoidanceAimUpAndDown(n6 >> 4, n5 >> 4, 1, by21);
                                    }
                                }
                            }
                            this.playerMoving[by4] = false;
                        } else {
                            this.playerDirection[by4] = by3;
                            this.playerMoving[by4] = true;
                        }
                    }
                }
                by4 = this.NextUnit(by4);
                by21 = (byte)(by21 + 1);
            }
            by4 = this.opponentArrayStart;
            while (by4 >= 0) {
                if (this.playerHealth[by4] >= 0 && this.playerY[by4] >= this.screenImageTop && this.playerY[by4] <= this.screenImageTop + this.height - 16 && this.playerX[by4] >= this.screenImageLeft && this.playerX[by4] <= this.screenImageLeft + this.width - 16) {
                    by2 = this.playerDirection[by4];
                    bl = true;
                    boolean bl7 = false;
                    by = this.currentPlayer;
                    while (bl) {
                        if (this.playerHealth[by] >= 0 && (this.playerType[by] != 3 || this.playerSpecial[by] < this.clockTicks) && this.playerY[by] >= this.screenImageTop && this.playerY[by] <= this.screenImageTop + this.height - 16 && this.playerX[by] >= this.screenImageLeft && this.playerX[by] <= this.screenImageLeft + this.width - 16) {
                            n6 = this.playerX[by] - this.playerX[by4];
                            n5 = this.playerY[by] - this.playerY[by4];
                            bl7 = true;
                            if (this.TargetAhead(by2, n6, n5) && this.ClearView(this.playerX[by4] + 8, this.playerY[by4] + 8, n6, n5)) {
                                by3 = this.GetDirection(n6, n5);
                                if (this.clockTicks > this.playerNextShot[by4]) {
                                    this.playerDirection[by4] = by3;
                                    this.StartProjectile(by4, (byte)99);
                                    this.playerNextShot[by4] = this.clockTicks + 20;
                                    break;
                                }
                                this.MoveEnemy(by4, by3);
                                break;
                            }
                        }
                        if ((by = this.NextUnit(by)) != this.currentPlayer) continue;
                        if (bl7 && (Math.abs(this.random.nextInt()) % 10 < 1 || !this.MoveEnemy(by4, this.playerDirection[by4]))) {
                            int n11 = Math.abs(this.random.nextInt()) % 10;
                            if (n11 < 4) {
                                this.MoveEnemy(by4, (byte)(8 - this.playerDirection[by4]));
                            } else if (n11 < 6) {
                                this.MoveEnemy(by4, (byte)7);
                            } else if (n11 < 8) {
                                this.MoveEnemy(by4, (byte)(n11 * 2 - 6));
                            } else {
                                this.MoveEnemy(by4, (byte)(n11 * 2 - 13));
                            }
                        }
                        bl = false;
                    }
                }
                by4 = this.playerArrayNext[by4];
            }
            this.StartSimpleTimer((short)0, 50);
        } else if (s == 1) {
            this.frameCount = (byte)(this.frameCount + 1);
            if (this.frameCount == 1) {
                this.splashImage = this.GetImage("nGame");
                this.StartSimpleTimer((short)1, 2000);
            } else if (this.frameCount == 2) {
                this.splashImage = this.GetImage("backdrop");
                this.StartSimpleTimer((short)1, 3000);
            } else {
                this.GetSound("background");
                this.GoToMainMenu(true);
            }
        } else if (s == 2) {
            this.frameCount = this.frameCount == 2 ? (byte)0 : (byte)(this.frameCount + 1);
            this.StartSimpleTimer((short)2, 100);
        } else if (s == 3) {
            this.allowKeyPresses = true;
        }
        this.repaint();
    }

    private byte NextUnit(byte by) {
        return this.NextUnitRecurse(by, by);
    }

    private byte NextUnitRecurse(byte by, byte by2) {
        byte by3 = this.playerArrayNext[by];
        if (by3 == this.opponentArrayStart) {
            by3 = this.playerArrayStart;
        }
        if (this.playerHealth[by3] >= 0 || by3 == by2) {
            return by3;
        }
        return this.NextUnitRecurse(by3, by2);
    }

    private void StartProjectile(byte by, byte by2) {
        if (this.projectileArrayUnusedStart >= 0) {
            byte by3 = this.StartProjectileCommonCode(by2);
            this.projectileDirection[by3] = this.playerDirection[by];
            if (by2 == 1) {
                byte by4 = this.opponentArrayStart;
                byte by5 = -1;
                int n = 99999999;
                int n2 = this.playerX[by];
                int n3 = this.playerY[by];
                while (by4 >= 0) {
                    if (this.playerHealth[by4] >= 0 && this.playerY[by4] >= this.screenImageTop && this.playerY[by4] <= this.screenImageTop + this.height - 16 && this.playerX[by4] >= this.screenImageLeft && this.playerX[by4] <= this.screenImageLeft + this.width - 16) {
                        int n4 = this.playerX[by4] - n2;
                        int n5 = this.playerY[by4] - n3;
                        int n6 = n4 > 0 ? n4 : -n4;
                        n6 = n5 > 0 ? (n6 += n5) : (n6 -= n5);
                        if (n6 < n && this.ClearView(n2 + 8, n3 + 8, n4, n5)) {
                            by5 = by4;
                            n = n6;
                        }
                    }
                    by4 = this.playerArrayNext[by4];
                }
                if (by5 >= 0) {
                    this.playerDirection[by] = this.GetDirection(this.playerX[by5] - n2, this.playerY[by5] - n3);
                    this.DoPlayerDamage(by5, (byte)2);
                }
                this.projectileX[by3] = this.playerX[by] + gunFlareX[this.playerDirection[by]];
                this.projectileY[by3] = this.playerY[by] + gunFlareY[this.playerDirection[by]];
            } else {
                this.projectileX[by3] = this.playerX[by] + 8;
                this.projectileY[by3] = this.playerY[by] + 8;
            }
        }
    }

    private void StartSmoke(int n, int n2) {
        if (this.projectileArrayUnusedStart >= 0) {
            byte by = this.StartProjectileCommonCode((byte)11);
            this.projectileDirection[by] = (byte)(Math.abs(this.random.nextInt()) % 8);
            if (this.projectileDirection[by] == 4) {
                this.projectileDirection[by] = 8;
            }
            this.projectileX[by] = n;
            this.projectileY[by] = n2;
        }
    }

    private byte StartProjectileCommonCode(byte by) {
        byte by2 = this.projectileArrayUnusedStart;
        this.projectileArrayUnusedStart = this.projectileArrayNext[by2];
        this.projectileArrayNext[by2] = this.projectileArrayUsedStart;
        this.projectileArrayUsedStart = by2;
        this.projectileType[by2] = by;
        this.projectileTime[by2] = 0;
        return by2;
    }

    private boolean TargetAhead(byte by, int n, int n2) {
        switch (by) {
            case 0: {
                return n <= -n2;
            }
            case 1: {
                return n2 <= 0;
            }
            case 2: {
                return n >= n2;
            }
            case 3: {
                return n <= 0;
            }
            case 5: {
                return n >= 0;
            }
            case 6: {
                return n2 >= n;
            }
            case 7: {
                return n2 >= 0;
            }
            case 8: {
                return n >= -n2;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean ClearView(int var1_1, int var2_2, int var3_3, int var4_4) {
        block8: {
            block7: {
                if (var3_3 < 0) {
                    var1_1 += var3_3;
                    var2_2 += var4_4;
                    var3_3 = -var3_3;
                    var4_4 = -var4_4;
                }
                var5_5 = var1_1 >> 4;
                var6_6 = var2_2 >> 4;
                var9_7 = var4_4 >= 0 ? 1 : -1;
                if (var3_3 != 0) break block7;
                var8_8 = var2_2 + var4_4 >> 4;
                if (this.TileBlockData[this.MapData[var6_6][var5_5]] > 1) ** GOTO lbl16
                return false;
lbl-1000:
                // 1 sources

                {
                    if (this.TileBlockData[this.MapData[var6_6][var5_5]] <= 1) {
                        return false;
                    }
                    var6_6 += var9_7;
lbl16:
                    // 2 sources

                    ** while (var6_6 != var8_8)
                }
lbl17:
                // 1 sources

                break block8;
            }
            var10_10 = (var4_4 << 10) / var3_3;
            var11_11 = (var2_2 << 10) - var10_10 * var1_1;
            var12_12 = var1_1 + var3_3;
            var13_13 = true;
            while (var13_13) {
                var7_14 = var5_5 + 1 << 4;
                if (var7_14 >= var12_12) {
                    var8_9 = var2_2 + var4_4 >> 4;
                    var13_13 = false;
                } else {
                    var8_9 = var7_14 * var10_10 + var11_11 >> 14;
                }
                if (this.TileBlockData[this.MapData[var6_6][var5_5]] > 1) ** GOTO lbl34
                return false;
lbl-1000:
                // 1 sources

                {
                    if (this.TileBlockData[this.MapData[var6_6 += var9_7][var5_5]] > 1) continue;
                    return false;
lbl34:
                    // 2 sources

                    ** while (var6_6 != var8_9)
                }
lbl35:
                // 1 sources

                var5_5 = var7_14 >> 4;
            }
        }
        return true;
    }

    private byte GetDirection(int n, int n2) {
        if (n == 0) {
            if (n2 > 0) {
                return 7;
            }
            return 1;
        }
        int n3 = (n2 << 10) / n;
        int n4 = n3 > 2472 ? 7 : (n3 > 424 ? 8 : (n3 > -424 ? 5 : (n3 > -2472 ? 2 : 1)));
        if (n > 0) {
            return (byte)n4;
        }
        return (byte)(8 - n4);
    }

    private boolean MoveEnemy(byte by, byte by2) {
        int n;
        int n2;
        int n3 = n2 = this.TileBlockData[this.MapData[this.playerY[by] + 8 >> 4][this.playerX[by] + 8 >> 4]] == 3 ? 1 : 2;
        if (by2 < 3) {
            n = this.MovePlayerUp(by, n2);
            if (n > 0) {
                byte by3 = by;
                this.playerY[by3] = this.playerY[by3] - n;
            } else {
                by2 = (byte)(by2 + 3);
            }
        } else if (by2 > 5) {
            n = this.MovePlayerDown(by, n2);
            if (n > 0) {
                byte by4 = by;
                this.playerY[by4] = this.playerY[by4] + n;
            } else {
                by2 = (byte)(by2 - 3);
            }
        }
        if (by2 % 3 == 0) {
            n = this.MovePlayerLeft(by, n2);
            if (n > 0) {
                byte by5 = by;
                this.playerX[by5] = this.playerX[by5] - n;
            } else {
                by2 = (byte)(by2 + 1);
            }
        } else if (by2 % 3 == 2) {
            n = this.MovePlayerRight(by, n2);
            if (n > 0) {
                byte by6 = by;
                this.playerX[by6] = this.playerX[by6] + n;
            } else {
                by2 = (byte)(by2 - 1);
            }
        }
        if (by2 == 4) {
            this.playerMoving[by] = false;
            return false;
        }
        this.playerDirection[by] = by2;
        this.playerMoving[by] = true;
        return true;
    }

    private void SetHidingAims(byte by) {
        byte by2 = this.NextUnit(by);
        byte by3 = -1;
        while (by2 != by) {
            this.SetHidingAimOneSide(by3, by2);
            by2 = this.NextUnit(by2);
            by3 = -by3;
        }
    }

    private void SetHidingAimOneSide(byte by, byte by2) {
        int n = (by + 1) / 2;
        int n2 = this.playerY[by2] >> 4;
        int n3 = 0;
        while (n3 <= 1) {
            int n4;
            int n5;
            if (by == -1) {
                n5 = this.playerX[by2] >> 4;
                if (n2 >= 1 && this.TileBlockData[this.MapData[n2 - 1][n5]] == 0 && this.StoreHidingAim(n, n2 << 4, n5 << 4)) {
                    return;
                }
                if (n2 >= 2 && this.TileBlockData[this.MapData[n2 - 2][n5]] == 0 && this.StoreHidingAim(n, n2 - 1 << 4, n5 << 4)) {
                    return;
                }
                n4 = n5 - 1;
            } else {
                n5 = this.playerX[by2] + 15 >> 4;
                if (n2 >= 1 && this.TileBlockData[this.MapData[n2 - 1][n5]] == 0 && this.StoreHidingAim(n, n2 << 4, n5 << 4)) {
                    return;
                }
                if (n2 >= 2 && this.TileBlockData[this.MapData[n2 - 2][n5]] == 0 && this.StoreHidingAim(n, n2 - 1 << 4, n5 << 4)) {
                    return;
                }
                n4 = n5 + 1;
            }
            if (n2 >= 1 && n4 >= 0 && n4 < 11 && this.TileBlockData[this.MapData[n2 - 1][n4]] == 0 && this.StoreHidingAim(n, n2 << 4, n4 << 4)) {
                return;
            }
            if (n2 >= 2 && n4 >= 0 && n4 < 11 && this.TileBlockData[this.MapData[n2 - 2][n4]] == 0 && this.StoreHidingAim(n, n2 - 1 << 4, n4 << 4)) {
                return;
            }
            int n6 = 0;
            while (n6 < 4 && n4 >= 0 && n4 < 11) {
                int n7 = 0;
                int n8 = n2 - 3;
                if (n8 < 0) {
                    n8 = 0;
                }
                boolean bl = false;
                while (n7 < 7 && n8 < 128) {
                    if (this.TileBlockData[this.MapData[n8][n4]] == 0) {
                        bl = true;
                    } else if (bl) {
                        if (this.StoreHidingAim(n, n8 << 4, n4 << 4)) {
                            return;
                        }
                        bl = false;
                    }
                    ++n7;
                    ++n8;
                }
                ++n6;
                n4 += by;
                if (!bl) continue;
                n6 = 99;
            }
            by = -by;
            ++n3;
        }
        this.playerAimX[n] = -1;
        this.playerAimY[n] = -1;
    }

    private boolean StoreHidingAim(int n, int n2, int n3) {
        if (n == 1 && this.playerAimX[0] == n3 && this.playerAimY[0] == n2) {
            return false;
        }
        this.playerAimX[n] = n3;
        this.playerAimY[n] = n2;
        return true;
    }

    private void SetAvoidanceAimUpAndDown(int n, int n2, int n3, byte by) {
        int n4 = n2 + n3;
        if (this.TileBlockData[this.MapData[n4][n]] > 1) {
            this.playerAimX[by] = n << 4;
            this.playerAimY[by] = n4 << 4;
        } else {
            boolean[] blArray = new boolean[]{true, true};
            boolean bl = true;
            int n5 = 1;
            while (bl) {
                if (blArray[0]) {
                    if (n < n5 || this.TileBlockData[this.MapData[n2][n - n5]] <= 1) {
                        blArray[0] = false;
                        if (!blArray[1]) {
                            bl = false;
                        }
                    } else if (this.TileBlockData[this.MapData[n4][n - n5]] > 1) {
                        this.playerAimX[by] = n - n5 << 4;
                        this.playerAimY[by] = n4 << 4;
                        bl = false;
                    }
                }
                if (blArray[1]) {
                    if (n >= 11 - n5 || this.TileBlockData[this.MapData[n2][n + n5]] <= 1) {
                        blArray[1] = false;
                        if (!blArray[0]) {
                            bl = false;
                        }
                    } else if (this.TileBlockData[this.MapData[n4][n + n5]] > 1) {
                        this.playerAimX[by] = n + n5 << 4;
                        this.playerAimY[by] = n4 << 4;
                        bl = false;
                    }
                }
                ++n5;
            }
        }
    }

    private void SetAvoidanceAimLeftAndRight(int n, int n2, int n3, byte by) {
        int n4 = n + n3;
        if (this.TileBlockData[this.MapData[n2][n4]] > 1) {
            this.playerAimX[by] = n4 << 4;
            this.playerAimY[by] = n2 << 4;
        } else {
            boolean[] blArray = new boolean[]{true, true};
            boolean bl = true;
            int n5 = 1;
            while (bl) {
                if (blArray[0]) {
                    if (n2 < n5 || this.TileBlockData[this.MapData[n2 - n5][n]] <= 1) {
                        blArray[0] = false;
                        if (!blArray[1]) {
                            bl = false;
                        }
                    } else if (this.TileBlockData[this.MapData[n2 - n5][n4]] > 1) {
                        this.playerAimX[by] = n4 << 4;
                        this.playerAimY[by] = n2 - n5 << 4;
                        bl = false;
                    }
                }
                if (blArray[1]) {
                    if (n2 >= 128 - n5 || this.TileBlockData[this.MapData[n2 + n5][n]] <= 1) {
                        blArray[1] = false;
                        if (!blArray[0]) {
                            bl = false;
                        }
                    } else if (this.TileBlockData[this.MapData[n2 + n5][n4]] > 1) {
                        this.playerAimX[by] = n4 << 4;
                        this.playerAimY[by] = n2 + n5 << 4;
                        bl = false;
                    }
                }
                ++n5;
            }
        }
    }

    private void MoveScreenUp(int n) {
        if (this.screenImageTop > 0) {
            if (n > 6) {
                n = 6;
            }
            this.screenImageTop -= n;
            if (this.screenImageTop < 0) {
                this.screenImageTop = 0;
            }
            if (this.screenImageDiscontinuity == 0) {
                this.screenImageDiscontinuity += this.screenImageHeight;
                this.screenSplit -= this.screenImageHeight;
            }
            if (this.screenImageHeight - this.screenImageDiscontinuity < this.screenSplit - this.screenImageTop) {
                this.screenImageDiscontinuity -= 16;
                int n2 = this.screenImageTop >> 4;
                int n3 = 10;
                while (n3 >= 0) {
                    this.screenImageGraphics.setClip(n3 << 4, this.screenImageDiscontinuity, 16, 16);
                    byte by = this.TileTextureData[this.MapData[n2][n3]];
                    if (by == 26) {
                        this.screenImageGraphics.drawImage(this.tilesImage, n3 - 0 << 4, this.screenImageDiscontinuity, 20);
                    } else if (by == 28) {
                        this.screenImageGraphics.setColor(0);
                        this.screenImageGraphics.fillRect(n3 << 4, this.screenImageDiscontinuity, 16, 16);
                    }
                    this.screenImageGraphics.drawImage(this.tilesImage, n3 - by << 4, this.screenImageDiscontinuity, 20);
                    --n3;
                }
            }
        }
    }

    private void MoveScreenDown(int n) {
        if (this.screenImageTop < 2048 - this.height) {
            if (n > 6) {
                n = 6;
            }
            this.screenImageTop += n;
            if (this.screenImageTop > 2048 - this.height) {
                this.screenImageTop = 2048 - this.height;
            }
            if (this.screenImageDiscontinuity == this.screenImageHeight) {
                this.screenImageDiscontinuity -= this.screenImageHeight;
                this.screenSplit += this.screenImageHeight;
            }
            if (this.screenImageDiscontinuity < this.screenImageTop + this.height - this.screenSplit) {
                this.screenImageDiscontinuity += 16;
                int n2 = this.screenImageTop + this.height >> 4;
                int n3 = 10;
                while (n3 >= 0) {
                    this.screenImageGraphics.setClip(n3 << 4, this.screenImageDiscontinuity - 16, 16, 16);
                    byte by = this.TileTextureData[this.MapData[n2][n3]];
                    if (by == 26) {
                        this.screenImageGraphics.drawImage(this.tilesImage, n3 - 0 << 4, this.screenImageDiscontinuity - 16, 20);
                    } else if (by == 28) {
                        this.screenImageGraphics.setColor(0);
                        this.screenImageGraphics.fillRect(n3 << 4, this.screenImageDiscontinuity - 16, 16, 16);
                    }
                    this.screenImageGraphics.drawImage(this.tilesImage, n3 - by << 4, this.screenImageDiscontinuity - 16, 20);
                    --n3;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int MovePlayerUp(byte by, int n) {
        int n2;
        byte by2;
        if (this.playerY[by] < n) return this.playerY[by];
        if ((this.playerY[by] & 0xF) < n) {
            by2 = 0;
            boolean bl = false;
            int n3 = 0;
            while (n3 <= 15) {
                n2 = this.MapData[(this.playerY[by] >> 4) - 1][this.playerX[by] + n3 >> 4];
                if (this.TileBlockData[n2] == 1) {
                    if (by >= 3 || this.playerType[by] != 3) return this.playerY[by] & 0xF;
                    if (by2 != 0) {
                        this.Infiltrate(by, true);
                    } else {
                        by2 = 1;
                    }
                } else {
                    if (this.TileBlockData[n2] == 0) {
                        return this.playerY[by] & 0xF;
                    }
                    if (this.TileBlockData[n2] == 5) {
                        if (by < 3 && this.playerType[by] == 3) {
                            if (bl) {
                                this.Infiltrate(by, false);
                            } else {
                                bl = true;
                            }
                        }
                    } else if (by == this.currentPlayer && (n2 = this.TileSpecialData[n2]) >= 0) {
                        this.PickUpItem(by, (byte)n2);
                    }
                }
                n3 += 15;
            }
        }
        by2 = this.playerArrayStart;
        while (by2 >= 0 && n > 0) {
            if (by2 != by && this.playerHealth[by2] >= 0 && (n2 = this.playerX[by] - this.playerX[by2]) > -16 && n2 < 16 && (n2 = this.playerY[by] - n - this.playerY[by2]) > -16 && n2 < 16) {
                n = this.playerY[by] - this.playerY[by2] - 16;
                this.CheckCollision(by, by2);
            }
            by2 = this.playerArrayNext[by2];
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int MovePlayerDown(byte by, int n) {
        int n2;
        byte by2;
        if (this.playerY[by] + n > 2032) return 2032 - this.playerY[by];
        if ((1 - this.playerY[by] & 0xF) <= n) {
            by2 = 0;
            boolean bl = false;
            int n3 = 0;
            while (n3 <= 15) {
                n2 = this.MapData[this.playerY[by] + n + 15 >> 4][this.playerX[by] + n3 >> 4];
                if (this.TileBlockData[n2] == 1) {
                    if (by >= 3 || this.playerType[by] != 3) return -this.playerY[by] & 0xF;
                    if (by2 != 0) {
                        this.Infiltrate(by, true);
                    } else {
                        by2 = 1;
                    }
                } else {
                    if (this.TileBlockData[n2] == 0) {
                        return -this.playerY[by] & 0xF;
                    }
                    if (this.TileBlockData[n2] == 5) {
                        if (by < 3 && this.playerType[by] == 3) {
                            if (bl) {
                                this.Infiltrate(by, false);
                            } else {
                                bl = true;
                            }
                        }
                    } else if (by == this.currentPlayer && (n2 = this.TileSpecialData[n2]) >= 0) {
                        this.PickUpItem(by, (byte)n2);
                    }
                }
                n3 += 15;
            }
        }
        by2 = this.playerArrayStart;
        while (by2 >= 0 && n > 0) {
            if (by2 != by && this.playerHealth[by2] >= 0 && (n2 = this.playerX[by] - this.playerX[by2]) > -16 && n2 < 16 && (n2 = this.playerY[by2] - this.playerY[by] - n) > -16 && n2 < 16) {
                n = this.playerY[by2] - this.playerY[by] - 16;
                this.CheckCollision(by, by2);
            }
            by2 = this.playerArrayNext[by2];
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int MovePlayerLeft(byte by, int n) {
        int n2;
        byte by2;
        if (this.playerX[by] < n) return this.playerX[by];
        if ((this.playerX[by] & 0xF) < n) {
            by2 = 0;
            boolean bl = false;
            int n3 = 0;
            while (n3 <= 15) {
                n2 = this.MapData[this.playerY[by] + n3 >> 4][(this.playerX[by] >> 4) - 1];
                if (this.TileBlockData[n2] == 1) {
                    if (by >= 3 || this.playerType[by] != 3) return this.playerX[by] & 0xF;
                    if (by2 != 0) {
                        this.Infiltrate(by, true);
                    } else {
                        by2 = 1;
                    }
                } else {
                    if (this.TileBlockData[n2] == 0) {
                        return this.playerX[by] & 0xF;
                    }
                    if (this.TileBlockData[n2] == 5) {
                        if (by < 3 && this.playerType[by] == 3) {
                            if (bl) {
                                this.Infiltrate(by, false);
                            } else {
                                bl = true;
                            }
                        }
                    } else if (by == this.currentPlayer && (n2 = this.TileSpecialData[n2]) >= 0) {
                        this.PickUpItem(by, (byte)n2);
                    }
                }
                n3 += 15;
            }
        }
        by2 = this.playerArrayStart;
        while (by2 >= 0 && n > 0) {
            if (by2 != by && this.playerHealth[by2] >= 0 && (n2 = this.playerY[by] - this.playerY[by2]) > -16 && n2 < 16 && (n2 = this.playerX[by] - n - this.playerX[by2]) > -16 && n2 < 16) {
                n = this.playerX[by] - this.playerX[by2] - 16;
                this.CheckCollision(by, by2);
            }
            by2 = this.playerArrayNext[by2];
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int MovePlayerRight(byte by, int n) {
        int n2;
        byte by2;
        if (this.playerX[by] + n > 160) return 160 - this.playerX[by];
        if ((1 - this.playerX[by] & 0xF) <= n) {
            by2 = 0;
            boolean bl = false;
            int n3 = 0;
            while (n3 <= 15) {
                n2 = this.MapData[this.playerY[by] + n3 >> 4][this.playerX[by] + n + 15 >> 4];
                if (this.TileBlockData[n2] == 1) {
                    if (by >= 3 || this.playerType[by] != 3) return -this.playerX[by] & 0xF;
                    if (by2 != 0) {
                        this.Infiltrate(by, true);
                    } else {
                        by2 = 1;
                    }
                } else {
                    if (this.TileBlockData[n2] == 0) {
                        return -this.playerX[by] & 0xF;
                    }
                    if (this.TileBlockData[n2] == 5) {
                        if (by < 3 && this.playerType[by] == 3) {
                            if (bl) {
                                this.Infiltrate(by, false);
                            } else {
                                bl = true;
                            }
                        }
                    } else if (by == this.currentPlayer && (n2 = this.TileSpecialData[n2]) >= 0) {
                        this.PickUpItem(by, (byte)n2);
                    }
                }
                n3 += 15;
            }
        }
        by2 = this.playerArrayStart;
        while (by2 >= 0 && n > 0) {
            if (by2 != by && this.playerHealth[by2] >= 0 && (n2 = this.playerY[by] - this.playerY[by2]) > -16 && n2 < 16 && (n2 = this.playerX[by2] - this.playerX[by] - n) > -16 && n2 < 16) {
                n = this.playerX[by2] - this.playerX[by] - 16;
                this.CheckCollision(by, by2);
            }
            by2 = this.playerArrayNext[by2];
        }
        return n;
    }

    private void CheckCollision(byte by, byte by2) {
        if (by == this.currentPlayer && this.playerType[by] == 4 && by2 < 3 && this.playerHealth[by] > 0 && this.clockTicks > this.playerNextShot[by]) {
            byte by3 = by2;
            this.playerHealth[by3] = (byte)(this.playerHealth[by3] + this.playerHealth[by]);
            this.playerNextShot[by] = this.clockTicks + 60;
            if (this.playerHealth[by2] > INITIAL_HEALTH[this.playerType[by2]]) {
                this.playerHealth[by2] = INITIAL_HEALTH[this.playerType[by2]];
            }
            this.playerShowStatus[by2] = this.clockTicks + 60;
        }
    }

    private void PickUpItem(byte by, byte by2) {
        switch (this.specialType[by2]) {
            case 5: {
                this.playerProtected[by] = this.clockTicks + 180;
                break;
            }
            case 6: {
                if (this.playerHealth[by] < INITIAL_HEALTH[this.playerType[by]]) {
                    this.playerShowStatus[by] = this.clockTicks + 60;
                    byte by3 = by;
                    this.playerHealth[by3] = (byte)(this.playerHealth[by3] + 1);
                    this.UpdateStatusBar();
                    break;
                }
                return;
            }
            case 7: {
                if (this.playerType[by] != 4 && this.playerType[by] != 3 && this.playerSpecial[by] < INITIAL_AMMO[WEAPON_TYPE[this.playerType[by]]]) {
                    this.playerSpecial[by] = INITIAL_AMMO[WEAPON_TYPE[this.playerType[by]]];
                    this.UpdateStatusBar();
                    break;
                }
                return;
            }
            case 8: {
                this.endLevel = true;
                return;
            }
        }
        this.TileSpecialData[this.MapData[this.specialY[by2] >> 4][this.specialX[by2] >> 4]] = -1;
        byte by4 = this.specialArrayPrevious[by2];
        if (by4 < 0) {
            this.specialArrayStart = this.specialArrayNext[by2];
        } else {
            this.specialArrayNext[by4] = this.specialArrayNext[by2];
        }
        by4 = this.specialArrayNext[by2];
        if (by4 >= 0) {
            this.specialArrayPrevious[by4] = this.specialArrayPrevious[by2];
        }
    }

    private void Infiltrate(byte by, boolean bl) {
        if (this.playerInBuilding[by]) {
            this.playerInBuilding[by] = false;
            if (this.clockTicks < this.playerSpecial[by]) {
                this.SetInvisibility(by, false);
            }
        } else {
            this.playerInBuilding[by] = true;
            if (bl) {
                this.SetInvisibility(by, true);
            }
        }
    }

    private void DoExplosion(byte by, int n) {
        int n2 = this.projectileX[by];
        int n3 = this.projectileY[by];
        this.CheckPlayerDamage(n2 + 16, n2 - 32, n3 + 16, n3 - 32, (byte)2);
        byte by2 = this.specialArrayExplodableStart;
        while (by2 >= 0) {
            byte by3 = this.specialType[by2];
            if (by3 >= 0 && n3 + 24 >= this.specialY[by2] && n3 - 24 <= this.specialY[by2] + SPECIAL_GFX_H[by3] && n2 + 24 >= this.specialX[by2] && n2 - 24 <= this.specialX[by2] + SPECIAL_GFX_W[by3]) {
                byte by4 = by2;
                this.specialDamage[by4] = (byte)(this.specialDamage[by4] - n);
                if (this.specialDamage[by2] <= 0) {
                    int n4 = this.specialX[by2] >> 4;
                    int n5 = this.specialY[by2] >> 4;
                    int n6 = (SPECIAL_GFX_W[by3] >> 4) - 1;
                    while (n6 >= 0) {
                        int n7 = (SPECIAL_GFX_H[by3] >> 4) - 1;
                        while (n7 >= 0) {
                            byte by5 = this.MapData[n5 + n7][n4 + n6];
                            this.TileSpecialData[by5] = -1;
                            this.TileBlockData[by5] = 4;
                            --n7;
                        }
                        --n6;
                    }
                    this.specialType[by2] = (byte)(-1 - by3);
                }
            }
            by2 = this.specialArrayNext[by2];
        }
        this.projectileType[by] = 10;
        this.projectileTime[by] = 0;
    }

    private boolean CheckPlayerDamage(int n, int n2, int n3, int n4, byte by) {
        boolean bl = false;
        byte by2 = this.playerArrayStart;
        while (by2 >= 0) {
            if (this.playerHealth[by2] >= 0 && this.playerX[by2] <= n && this.playerX[by2] > n2 && this.playerY[by2] <= n3 && this.playerY[by2] > n4) {
                this.DoPlayerDamage(by2, by);
                bl = true;
            }
            if ((by2 = this.playerArrayNext[by2]) != this.opponentArrayStart) continue;
            n += 2;
            n2 -= 2;
            n3 += 2;
            n4 -= 2;
        }
        return bl;
    }

    private void DoPlayerDamage(byte by, byte by2) {
        if (by >= 3 || this.clockTicks > this.playerProtected[by]) {
            byte by3 = by;
            this.playerHealth[by3] = (byte)(this.playerHealth[by3] - by2);
            if (this.playerHealth[by] < -1) {
                this.playerHealth[by] = -1;
            }
            if (by < 3) {
                this.playerShowStatus[by] = this.clockTicks + 60;
            }
            if (by == this.currentPlayer) {
                if (this.playerHealth[by] < 0) {
                    this.currentPlayer = this.NextUnit(by);
                    this.playerDirection[this.currentPlayer] = 1;
                }
                this.UpdateStatusBar();
            }
        }
    }

    private void SetMenuScreenType(short s) {
        int n;
        this.menuGraphicHeight = (short)(4 + this.largeFontHeight + 3);
        this.menuLineHeight = this.fontHeight;
        int n2 = this.largeFontHeight + 4;
        if (s >= 100) {
            if (this.is3650 && s == 105) {
                this.SetMenuScreenParseText(Strings.helpText[7]);
            } else {
                this.SetMenuScreenParseText(Strings.helpText[s - 100]);
            }
        } else if (s == 7 || s == 8) {
            if (this.missionTime[this.missionNumberCurrent] > 0) {
                this.SetMenuScreenParseText(Strings.missionBriefing[this.missionNumberCurrent] + "~ ~Best time: " + this.missionTime[this.missionNumberCurrent] / 10 + "." + this.missionTime[this.missionNumberCurrent] % 10);
            } else {
                this.SetMenuScreenParseText(Strings.missionBriefing[this.missionNumberCurrent]);
            }
        } else if (s == 11) {
            n = (int)((System.currentTimeMillis() - this.startTime) / 100L);
            if (this.missionTime[this.missionNumberCurrent] == 0 || n < this.missionTime[this.missionNumberCurrent]) {
                this.missionTime[this.missionNumberCurrent] = n;
                this.writeRecords();
                this.SetMenuScreenParseText(Strings.missionDebrief[this.missionNumberCurrent] + "~ ~New best time: " + n / 10 + "." + n % 10);
            } else {
                this.SetMenuScreenParseText(Strings.missionDebrief[this.missionNumberCurrent] + "~ ~Time: " + n / 10 + "." + n % 10);
            }
        } else if (s == 14) {
            this.menuGraphicHeight = (short)(4 + this.titleImage.getHeight() + 3);
            this.SetMenuScreenParseText("Call of Duty is available now on PC.  24 epic single player missions - spanning four campaigns with one goal - Berlin.  Download the demo at www.callofduty.com.");
        } else {
            this.menuLineHeight = this.largeFontHeight;
            if (s == 3) {
                this.menuStringArray = Strings.helpTitles;
                this.clockTicks = 0;
            } else if (s == 1) {
                this.menuStringArray = new String[]{"Play", "Options", "Help", "Exit"};
                n2 = 4;
                this.menuGraphicHeight = (short)(4 + this.titleImage.getHeight() + 3);
                this.menuLineHeight = (short)30;
            } else if (s == 6) {
                this.menuStringArray = new String[this.missionNumberMax + 1];
                n = 0;
                while (n <= this.missionNumberMax) {
                    this.menuStringArray[n] = Strings.missionTitle[this.missionNumberMax - n];
                    ++n;
                }
                this.menuGraphicHeight = (short)(4 + this.titleImage.getHeight() + 3);
            } else if (s == 4) {
                this.menuStringArray = new String[]{this.soundOn ? "Sound: ON" : "Sound: OFF", "Reset Game"};
            } else if (s == 5) {
                this.menuStringArray = new String[]{this.soundOn ? "Sound: ON" : "Sound: OFF", "Restart Mission", "Main Menu"};
            }
            this.menuSelection = 1;
        }
        this.menuLength = (short)this.menuStringArray.length;
        this.screenType = s;
        this.menuStart = 1;
        this.menuLines = (short)Math.min((this.height - this.menuGraphicHeight - n2) / this.menuLineHeight, this.menuLength);
        n = this.height - this.menuGraphicHeight - n2 - this.menuLines * this.menuLineHeight >> 1;
        if (n > 0) {
            this.menuGraphicHeight = (short)(this.menuGraphicHeight + n);
        }
    }

    private void SetMenuScreenParseText(String string) {
        Vector vector = this.ParseString(string);
        this.menuStringArray = new String[vector.size() - 1];
        int n = vector.size() - 2;
        while (n >= 0) {
            this.menuStringArray[n] = string.substring((Integer)vector.elementAt(n), (Integer)vector.elementAt(n + 1) - 1);
            --n;
        }
        this.menuSelection = 0;
    }

    private Vector ParseString(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = this.width - 14 - 8;
        while (n < n3) {
            vector.addElement(new Integer(n));
            n2 = n;
            int n5 = 0;
            while (n5 < n4 && n < n3 && string.charAt(n) != '~') {
                n5 += this.font.charWidth(string.charAt(n));
                ++n;
            }
            if (n5 >= n4) {
                int n6 = --n;
                while (n6 > n2 && string.charAt(n6) != ' ') {
                    --n6;
                }
                if (n6 <= n2) continue;
                n = n6 + 1;
                continue;
            }
            ++n;
        }
        vector.addElement(new Integer(n));
        return vector;
    }
}

